/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.time;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationFieldType;
import org.joda.time.PeriodType;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public enum DTimeUnit {
    ALL_TIME(null, null, null, new DateTimeFormatterBuilder().appendLiteral("All Time").toFormatter()),
    MINUTE(PeriodType.minutes(), DurationFieldType.minutes(), DateTimeFieldType.minuteOfHour(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm")),
    HOUR(PeriodType.hours(), DurationFieldType.hours(), DateTimeFieldType.hourOfDay(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH")),
    LAST24(PeriodType.minutes(), DurationFieldType.minutes(), DateTimeFieldType.minuteOfHour(), DateTimeFormat.forPattern((String)"yyyy-MM-dd")),
    DAY(PeriodType.days(), DurationFieldType.days(), DateTimeFieldType.dayOfMonth(), DateTimeFormat.forPattern((String)"yyyy-MM-dd")),
    WEEK(PeriodType.weeks(), DurationFieldType.weeks(), DateTimeFieldType.weekOfWeekyear(), DateTimeFormat.forPattern((String)"xxxx-'W'ww")),
    MONTH(PeriodType.months(), DurationFieldType.months(), DateTimeFieldType.monthOfYear(), DateTimeFormat.forPattern((String)"yyyy-MM"));

    private DateTimeFieldType dateTimeFieldType;
    private DurationFieldType durationFieldType;
    private PeriodType periodType;
    private DateTimeFormatter format;

    private DTimeUnit(PeriodType periodType, DurationFieldType durationFieldType, DateTimeFieldType dateTimeFieldType, DateTimeFormatter format) {
        this.periodType = periodType;
        this.durationFieldType = durationFieldType;
        this.dateTimeFieldType = dateTimeFieldType;
        this.format = format;
    }

    public DurationFieldType toDurationFieldType() {
        return this.durationFieldType;
    }

    public PeriodType toPeriodType() {
        return this.periodType;
    }

    public DateTimeFieldType toDateTimeFieldType() {
        return this.dateTimeFieldType;
    }

    public DateTimeFormatter getFormat() {
        return this.format;
    }
}

