/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.time;

import com.addthis.basis.time.DTimeUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class Dates {
    public static final DateTimeFormatter rfc1123 = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss Z");
    public static final DateTimeFormatter yMdFormat = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    public static final DateTimeFormatter yMdHFormat = DateTimeFormat.forPattern((String)"yyMMddHH");

    public static Period period(int length, PeriodType type) {
        return new Period(null, type).withField(type.getFieldType(0), length);
    }

    public static Interval truncateInterval(Interval interval, int limit, PeriodType type) {
        Interval truncatedInterval = interval;
        if (type != null) {
            DateTime now = new DateTime();
            if (interval.getEnd().isAfter((ReadableInstant)now)) {
                truncatedInterval = interval.getStart().isAfter((ReadableInstant)now) ? new Interval((ReadableInstant)now, (ReadableInstant)now) : interval.withEnd((ReadableInstant)now);
            }
            if (truncatedInterval.toPeriod(type).getValue(0) > --limit) {
                Period limitPeriod = Dates.period(limit, type);
                DateTime truncatedStart = truncatedInterval.getEnd().minus((ReadablePeriod)limitPeriod);
                truncatedInterval = truncatedInterval.withStart((ReadableInstant)truncatedStart);
            }
        }
        return truncatedInterval;
    }

    public static Interval parseInterval(String begStr, String endStr, DateTimeFormatter format) {
        DateTime beg = null;
        DateTime end = null;
        boolean begFailed = false;
        boolean endFailed = false;
        try {
            beg = format.parseDateTime(begStr);
        }
        catch (Exception e) {
            begFailed = true;
        }
        try {
            end = format.parseDateTime(endStr);
        }
        catch (Exception e) {
            endFailed = true;
        }
        if (begFailed && endFailed) {
            end = beg = new DateTime();
        } else if (begFailed) {
            beg = end;
        } else if (endFailed) {
            end = beg;
        }
        if (beg.isAfter((ReadableInstant)end)) {
            beg = end;
        }
        return new Interval((ReadableInstant)beg, (ReadableInstant)end);
    }

    public static Interval parseInterval(String begStr, String endStr) {
        return Dates.parseInterval(begStr, endStr, yMdFormat);
    }

    public static Date endOfDay(Date d) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(d);
        calendar.set(9, 1);
        calendar.set(14, ((Calendar)calendar).getActualMaximum(14));
        calendar.set(13, ((Calendar)calendar).getActualMaximum(13));
        calendar.set(12, ((Calendar)calendar).getActualMaximum(12));
        calendar.set(10, ((Calendar)calendar).getActualMaximum(10));
        return calendar.getTime();
    }

    public static Date begOfDay(Date d) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(d);
        calendar.set(9, 0);
        calendar.set(14, ((Calendar)calendar).getActualMinimum(14));
        calendar.set(13, ((Calendar)calendar).getActualMinimum(13));
        calendar.set(12, ((Calendar)calendar).getActualMinimum(12));
        calendar.set(10, ((Calendar)calendar).getActualMinimum(10));
        return calendar.getTime();
    }

    public static Iterable<DateTime> iterableInterval(Interval interval, DTimeUnit type) {
        return new IterableInterval(interval, type);
    }

    public static Iterator<DateTime> intervalIterator(Interval interval, DTimeUnit type) {
        return new IterableInterval(interval, type);
    }

    private static class IterableInterval
    implements Iterable<DateTime>,
    Iterator<DateTime> {
        private DateTime end;
        private DateTime currentInstant;
        private Period increment;

        public IterableInterval(Interval interval, DTimeUnit per) {
            if (per == DTimeUnit.ALL_TIME) {
                this.increment = Dates.period(1, PeriodType.millis());
                this.end = interval.getStart();
                this.currentInstant = this.end.minus((ReadablePeriod)this.increment);
            } else {
                this.increment = Dates.period(1, per.toPeriodType());
                this.end = interval.getEnd().property(per.toDateTimeFieldType()).roundFloorCopy();
                this.currentInstant = interval.getStart().minus((ReadablePeriod)this.increment);
            }
        }

        @Override
        public Iterator<DateTime> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.currentInstant.isBefore((ReadableInstant)this.end);
        }

        @Override
        public DateTime next() {
            this.currentInstant = this.currentInstant.plus((ReadablePeriod)this.increment);
            return this.currentInstant;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

