/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.util;

import com.addthis.basis.util.LessBytes;
import com.google.common.io.BaseEncoding;

public class Base64 {
    private static final BaseEncoding base64 = BaseEncoding.base64();
    private static final BaseEncoding base64Url = BaseEncoding.base64Url();

    public static void main(String[] args) {
        System.out.println("decode(" + args[0] + ") = " + Base64.decode(args[0]));
        System.out.println("encode(" + args[0] + ") = " + Base64.encode(args[0]));
    }

    public static String encode(String s) {
        return base64.encode(LessBytes.toBytes(s));
    }

    public static String encodeURLSafe(String s) {
        return base64Url.encode(LessBytes.toBytes(s));
    }

    public static char[] encode(byte[] in) {
        return base64.encode(in).toCharArray();
    }

    public static char[] encodeURLSafe(byte[] in) {
        return base64Url.encode(in).toCharArray();
    }

    public static String decode(String s) {
        return LessBytes.toString(base64.decode((CharSequence)s));
    }

    public static String decode(String s, boolean strict) {
        return Base64.decode(s);
    }

    public static String decodeURLSafe(String s) {
        return LessBytes.toString(base64Url.decode((CharSequence)s));
    }

    public static String decodeURLSafe(String s, boolean strict) {
        return Base64.decodeURLSafe(s);
    }

    public static byte[] decode(char[] in) {
        return base64.decode((CharSequence)new String(in));
    }

    public static byte[] decode(char[] in, boolean strict) {
        return Base64.decode(in);
    }

    public static byte[] decodeURLSafe(char[] in) {
        return base64Url.decode((CharSequence)new String(in));
    }

    public static byte[] decodeURLSafe(char[] in, boolean strict) {
        return Base64.decodeURLSafe(in);
    }
}

