/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.util;

import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicLong;

public final class Bench {
    private long mark;
    private long rate;
    private String[] names;
    private AtomicLong[] counts;
    private long[] rates;
    private long marks;

    public Bench() {
        this(new String[]{"tick"}, 1000L);
    }

    public Bench(String name, long rate) {
        this(new String[]{name}, rate);
    }

    public Bench(EnumSet set, long rate) {
        Enum[] e = new Enum[set.size()];
        set.toArray(e);
        String[] nm = new String[e.length];
        for (int i = 0; i < nm.length; ++i) {
            nm[i] = e[i].name();
        }
        this.setNames(nm);
        this.setPeriod(rate);
        this.mark();
        this.marks = 0L;
    }

    public Bench(String[] names, long rate) {
        this.setNames(names);
        this.setPeriod(rate);
        this.mark();
        this.marks = 0L;
    }

    public void setNames(String[] name) {
        assert (name != null && name.length > 0);
        this.names = name;
        this.rates = new long[name.length];
        this.counts = new AtomicLong[name.length];
        for (int i = 0; i < name.length; ++i) {
            this.counts[i] = new AtomicLong(0L);
        }
    }

    public void setPeriod(long rate) {
        this.rate = rate;
    }

    public long getPeriod() {
        return this.rate;
    }

    public long getMarkCalls() {
        return this.marks;
    }

    public synchronized long maxEvents(int which, long ev) {
        this.counts[which].set(Math.max(this.counts[which].get(), ev));
        return this.counts[which].get();
    }

    public long maxEvents(Enum which, long ev) {
        return this.maxEvents(which.ordinal(), ev);
    }

    public long addEvents(int which, long ev) {
        return this.counts[which].getAndAdd(ev);
    }

    public long addEvents(Enum which, long ev) {
        return this.addEvents(which.ordinal(), ev);
    }

    public synchronized long deltaEvents(int which, long ev) {
        this.rates[which] = -1L;
        long ret = ev - this.counts[which].get();
        this.counts[which].set(ev);
        return ret;
    }

    public long deltaEvents(Enum which, long ev) {
        return this.deltaEvents(which.ordinal(), ev);
    }

    public synchronized long mark() {
        long time = System.currentTimeMillis();
        for (int i = 0; i < this.names.length; ++i) {
            if (this.rates[i] < 0L) continue;
            this.rates[i] = this.counts[i].get() * this.rate / (time - this.mark + 1L);
            this.counts[i].set(0L);
        }
        this.mark = time;
        ++this.marks;
        return this.rates[0];
    }

    public long getLastTime() {
        return this.mark;
    }

    public long getEventCount(int which) {
        return this.counts[which].get();
    }

    public long getEventCount(Enum which) {
        return this.getEventCount(which.ordinal());
    }

    public long getEventRate(int which) {
        assert (which >= 0 && which < this.names.length);
        return this.rates[which];
    }

    public long getEventRate(Enum which) {
        return this.getEventRate(which.ordinal());
    }

    public long getPeriodRemaining() {
        return this.mark + this.rate - System.currentTimeMillis();
    }

    public boolean periodHasElapsed() {
        return this.hasElapsed(this.rate);
    }

    public boolean hasElapsed(long time) {
        return this.sinceLastMark() >= time;
    }

    public long sinceLastMark() {
        return System.currentTimeMillis() - this.mark;
    }
}

