/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.util;

import com.addthis.basis.util.LessNumbers;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;

public class CUID {
    private static final HashFunction fallbackHashFunc = Hashing.murmur3_128();

    public static String createAPIKey() {
        return CUID.createGUID();
    }

    @Deprecated
    public static String createGUID(int base) {
        return LessNumbers.nextLong(base) + LessNumbers.nextLong(base);
    }

    @Deprecated
    public static String createGUID() {
        return CUID.createGUID(LessNumbers.MAX_BASE);
    }

    public static String createCUID() {
        return CUID.createCUID(System.currentTimeMillis(), LessNumbers.random.nextInt());
    }

    public static String createCUID(long time, int rand) {
        return CUID.encodeCUID(time / 1000L << 32 | (long)rand & 0xFFFFFFFFL);
    }

    public static long cuidToTime(String cuid) {
        long val = CUID.decodeCUID(cuid);
        return (val >> 32) * 1000L;
    }

    public static long cuidToTime(long cuid) {
        return (cuid >> 32) * 1000L;
    }

    public static String encodeCUID(long cuid) {
        return Long.toHexString(cuid);
    }

    public static long decodeCUID(String cuid) {
        if (cuid == null || cuid.length() == 0) {
            return 0L;
        }
        try {
            return LessNumbers.longFromBase(cuid, 16, true);
        }
        catch (Exception ex) {
            System.out.println("invalid cuid : " + cuid);
            return fallbackHashFunc.hashUnencodedChars((CharSequence)cuid).asLong();
        }
    }
}

