/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.util;

import com.addthis.basis.util.DictUtil;
import com.addthis.basis.util.Multidict;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Dict {
    private Map<String, String> map;

    public Dict() {
        this.map = new LinkedHashMap<String, String>();
    }

    public Dict(Map<String, String> map) {
        assert (map != null);
        this.map = map;
    }

    public Dict(String query) {
        this.map = DictUtil.parse(query);
    }

    public Dict(String key, String value) {
        this();
        this.put(key, value);
    }

    public String put(String key, String value) {
        return this.map.put(key, value);
    }

    public String put(String key, int value) {
        return this.map.put(key, String.valueOf(value));
    }

    public String put(String key, long value) {
        return this.map.put(key, String.valueOf(value));
    }

    public String put(String key, double value) {
        return this.map.put(key, String.valueOf(value));
    }

    public String put(String key, float value) {
        return this.map.put(key, String.valueOf(value));
    }

    public String put(String key, boolean value) {
        return this.map.put(key, String.valueOf(value));
    }

    public <T extends Enum<T>> String put(String key, T value) {
        return this.map.put(key, String.valueOf(value));
    }

    public <T extends Enum<T>> String put(T value) {
        return value == null ? null : this.map.put(value.getClass().getSimpleName().toLowerCase(), String.valueOf(value));
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public String get(String key) {
        return this.map.get(key);
    }

    public String get(String key, String dflt) {
        return this.has(key) ? this.map.get(key) : dflt;
    }

    public int getInt(String key, int dflt) {
        try {
            return this.has(key) ? Integer.parseInt(this.map.get(key)) : dflt;
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public long getLong(String key, long dflt) {
        try {
            return this.has(key) ? Long.parseLong(this.map.get(key)) : dflt;
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public float getFloat(String key, float dflt) {
        try {
            return this.has(key) ? Float.parseFloat(this.map.get(key)) : dflt;
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public double getDouble(String key, double dflt) {
        try {
            return this.has(key) ? Double.parseDouble(this.map.get(key)) : dflt;
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public boolean getBoolean(String key, boolean dflt) {
        try {
            return this.has(key) ? Boolean.parseBoolean(this.map.get(key)) : dflt;
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public String toString() {
        return DictUtil.toString(this.map);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Dict)) {
            return false;
        }
        Dict that = (Dict)obj;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public int size() {
        return this.map.size();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public Multidict asMultidict() {
        return DictUtil.asMultidict(this);
    }
}

