/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.util;

import com.addthis.basis.util.Dict;
import com.addthis.basis.util.LessBytes;
import com.addthis.basis.util.LessStrings;
import com.addthis.basis.util.Multidict;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DictUtil {
    public static Map<String, String> parse(String query) {
        return DictUtil.parse(query, new LinkedHashMap<String, String>());
    }

    public static Map<String, String> parse(String query, Map<String, String> map) {
        assert (map != null);
        int i = 0;
        int j = query.indexOf("&");
        while (j >= 0) {
            if (j > 0) {
                DictUtil.parseParam(query.substring(i, j), map);
            }
            i = j + 1;
            j = query.indexOf("&", i);
        }
        DictUtil.parseParam(query.substring(i), map);
        return map;
    }

    public static Map<String, String> parseParam(String str, Map<String, String> map) {
        if (LessStrings.isEmpty(str)) {
            return map;
        }
        int sep = str.indexOf(61);
        if (sep < 0) {
            map.put(DictUtil.urlDecode(str), null);
        } else if (sep != 0) {
            if (sep < str.length() - 1) {
                map.put(LessBytes.urldecode(str.substring(0, sep)), LessBytes.urldecode(str.substring(sep + 1)));
            } else {
                map.put(LessBytes.urldecode(str.substring(0, sep)), "");
            }
        }
        return map;
    }

    public static String toString(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, String>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            if (entry.getValue() == null) {
                sb.append(DictUtil.urlEncode(entry.getKey()));
            } else {
                sb.append(DictUtil.urlEncode(entry.getKey())).append("=").append(DictUtil.urlEncode(entry.getValue()));
            }
            if (!i.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    public static Multidict asMultidict(Dict dict) {
        Multidict multidict = new Multidict();
        for (String key : dict.keySet()) {
            multidict.put(key, dict.get(key));
        }
        return multidict;
    }

    private static String urlEncode(String string) {
        try {
            return string == null ? string : URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private static String urlDecode(String string) {
        try {
            return string == null ? string : URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

