/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.util;

import com.addthis.basis.util.Parameter;
import com.google.common.util.concurrent.Uninterruptibles;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCInspector {
    private static final Logger logger = LoggerFactory.getLogger(GCInspector.class);
    static final long INTERVAL_IN_MS = 1000L;
    static final long MIN_DURATION = Parameter.intValue("basis.gcinspector.min_duration", 200);
    public static final GCInspector instance = new GCInspector();
    private final Map<String, Long> gctimes = new HashMap<String, Long>();
    private final Map<String, Long> gccounts = new HashMap<String, Long>();
    final List<GarbageCollectorMXBean> beans = new ArrayList<GarbageCollectorMXBean>();
    final MemoryMXBean membean = ManagementFactory.getMemoryMXBean();

    public GCInspector() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName gcName = new ObjectName("java.lang:type=GarbageCollector,*");
            for (ObjectName name : server.queryNames(gcName, null)) {
                GarbageCollectorMXBean gc = ManagementFactory.newPlatformMXBeanProxy(server, name.getCanonicalName(), GarbageCollectorMXBean.class);
                this.beans.add(gc);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
        try {
            if (this.beans.size() == 0) {
                return;
            }
            Thread t = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        GCInspector.this.logGCResults();
                        Uninterruptibles.sleepUninterruptibly((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                }
            };
            t.setName("GCInspector");
            t.setDaemon(true);
            t.start();
        }
        catch (Throwable e) {
            logger.warn("Unable to start GCInspector.  The may be because your JVM does not support the same beans as HotSpot", e);
        }
    }

    private void logGCResults() {
        for (GarbageCollectorMXBean gc : this.beans) {
            Long previousTotal = this.gctimes.get(gc.getName());
            Long total = gc.getCollectionTime();
            if (previousTotal == null) {
                previousTotal = 0L;
            }
            if (previousTotal.equals(total)) continue;
            this.gctimes.put(gc.getName(), total);
            Long duration = total - previousTotal;
            Long previousCount = this.gccounts.get(gc.getName());
            Long count = gc.getCollectionCount();
            if (previousCount == null) {
                previousCount = 0L;
            }
            if (count.equals(previousCount)) continue;
            this.gccounts.put(gc.getName(), count);
            MemoryUsage mu = this.membean.getHeapMemoryUsage();
            long memoryUsed = mu.getUsed();
            long memoryMax = mu.getMax();
            String st = String.format("GC for %s: %s ms for %s collections, %s used; max is %s", gc.getName(), duration, count - previousCount, memoryUsed, memoryMax);
            long durationPerCollection = duration / (count - previousCount);
            if (durationPerCollection > MIN_DURATION) {
                logger.info(st);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug(st);
        }
    }
}

