/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.util;

public final class JitterClock
extends Thread {
    private static final JitterClock singleton = new JitterClock(10L);
    private static volatile long time;
    private final long jitter;

    public static long globalTime() {
        return time;
    }

    private JitterClock(long jitter) {
        super("JitterClock jitter=" + jitter);
        this.jitter = jitter;
        this.setDaemon(true);
        this.update();
        this.start();
    }

    private void update() {
        time = System.currentTimeMillis();
    }

    @Override
    public void run() {
        while (true) {
            try {
                JitterClock.sleep(this.jitter);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.update();
        }
    }
}

