/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.util;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.net.UrlEscapers;
import com.google.common.primitives.UnsignedBytes;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class LessBytes {
    @Deprecated
    public static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final boolean nativeURLCodec = System.getProperty("nativeURLCodec", "1").equals("1");
    private static final byte[] emptyBytes = new byte[0];
    private static final int[] BitReverseTable256 = new int[]{0, 128, 64, 192, 32, 160, 96, 224, 16, 144, 80, 208, 48, 176, 112, 240, 8, 136, 72, 200, 40, 168, 104, 232, 24, 152, 88, 216, 56, 184, 120, 248, 4, 132, 68, 196, 36, 164, 100, 228, 20, 148, 84, 212, 52, 180, 116, 244, 12, 140, 76, 204, 44, 172, 108, 236, 28, 156, 92, 220, 60, 188, 124, 252, 2, 130, 66, 194, 34, 162, 98, 226, 18, 146, 82, 210, 50, 178, 114, 242, 10, 138, 74, 202, 42, 170, 106, 234, 26, 154, 90, 218, 58, 186, 122, 250, 6, 134, 70, 198, 38, 166, 102, 230, 22, 150, 86, 214, 54, 182, 118, 246, 14, 142, 78, 206, 46, 174, 110, 238, 30, 158, 94, 222, 62, 190, 126, 254, 1, 129, 65, 193, 33, 161, 97, 225, 17, 145, 81, 209, 49, 177, 113, 241, 9, 137, 73, 201, 41, 169, 105, 233, 25, 153, 89, 217, 57, 185, 121, 249, 5, 133, 69, 197, 37, 165, 101, 229, 21, 149, 85, 213, 53, 181, 117, 245, 13, 141, 77, 205, 45, 173, 109, 237, 29, 157, 93, 221, 61, 189, 125, 253, 3, 131, 67, 195, 35, 163, 99, 227, 19, 147, 83, 211, 51, 179, 115, 243, 11, 139, 75, 203, 43, 171, 107, 235, 27, 155, 91, 219, 59, 187, 123, 251, 7, 135, 71, 199, 39, 167, 103, 231, 23, 151, 87, 215, 55, 183, 119, 247, 15, 143, 79, 207, 47, 175, 111, 239, 31, 159, 95, 223, 63, 191, 127, 255};

    private LessBytes() {
    }

    public static byte[] cat(byte[] a, byte[] b) {
        byte[] o = new byte[a.length + b.length];
        System.arraycopy(a, 0, o, 0, a.length);
        System.arraycopy(b, 0, o, a.length, b.length);
        return o;
    }

    public static byte[] cat(byte[] a, byte[] b, byte[] c) {
        byte[] o = new byte[a.length + b.length + c.length];
        System.arraycopy(a, 0, o, 0, a.length);
        System.arraycopy(b, 0, o, a.length, b.length);
        System.arraycopy(c, 0, o, a.length + b.length, c.length);
        return o;
    }

    public static byte[] cat(byte[] a, byte[] b, byte[] c, byte[] d) {
        byte[] o = new byte[a.length + b.length + c.length + d.length];
        System.arraycopy(a, 0, o, 0, a.length);
        System.arraycopy(b, 0, o, a.length, b.length);
        System.arraycopy(c, 0, o, a.length + b.length, c.length);
        System.arraycopy(d, 0, o, a.length + b.length + c.length, d.length);
        return o;
    }

    public static byte[] cat(byte[] a, byte[] b, byte[] c, byte[] d, byte[] e) {
        byte[] o = new byte[a.length + b.length + c.length + d.length + e.length];
        System.arraycopy(a, 0, o, 0, a.length);
        System.arraycopy(b, 0, o, a.length, b.length);
        System.arraycopy(c, 0, o, a.length + b.length, c.length);
        System.arraycopy(d, 0, o, a.length + b.length + c.length, d.length);
        System.arraycopy(e, 0, o, a.length + b.length + c.length + d.length, e.length);
        return o;
    }

    public static byte[] replace(byte[] buf, byte[] pat, byte[] rep) {
        int startoff = 0;
        for (int scanpos = 0; scanpos < buf.length; ++scanpos) {
            if (buf[scanpos] == pat[startoff]) {
                if (++startoff != pat.length) continue;
                byte[] out = new byte[buf.length - pat.length + rep.length];
                Arrays.fill(out, (byte)45);
                System.arraycopy(buf, 0, out, 0, scanpos - startoff + 1);
                System.arraycopy(rep, 0, out, scanpos - startoff + 1, rep.length);
                System.arraycopy(buf, scanpos + 1, out, scanpos - startoff + rep.length + 1, out.length - scanpos - rep.length + pat.length - 1);
                return out;
            }
            startoff = 0;
        }
        return buf;
    }

    public static boolean overwrite(byte[] buf, byte[] pat, byte[] rep) {
        for (int i = 0; i < buf.length; ++i) {
            for (int j = 0; j < pat.length && i + j < buf.length && buf[i + j] == pat[j]; ++j) {
                if (j != pat.length - 1) continue;
                for (int r = 0; r < rep.length && i + r < buf.length; ++r) {
                    buf[i + r] = rep[r];
                }
                return true;
            }
        }
        return false;
    }

    public static boolean startsWith(byte[] data, byte[] prefix) {
        if (data.length >= prefix.length) {
            for (int i = 0; i < prefix.length; ++i) {
                if (data[i] == prefix[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static long toUnsignedInt(int i) {
        return ((long)(i >> 16) & 0xFFFFL) << 16 | (long)i & 0xFFFFL;
    }

    @Deprecated
    public static byte[] toBytes(String s) {
        try {
            return s.getBytes(UTF8);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return s.getBytes();
        }
    }

    @Nullable
    @Deprecated
    public static String toString(@Nullable byte[] b) {
        return b != null ? new String(b, UTF8) : null;
    }

    public static byte[][] toByteArrays(String ... strings) {
        byte[][] bytes = new byte[strings.length][0];
        for (int i = 0; i < strings.length; ++i) {
            bytes[i] = strings[i].getBytes(UTF8);
        }
        return bytes;
    }

    public static String[] toStrings(byte[][] bytes) {
        String[] strings = new String[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            strings[i] = new String(bytes[i], UTF8);
        }
        return strings;
    }

    @Deprecated
    public static byte[] toBytes(short val) {
        byte[] data = new byte[]{(byte)((val & 0xFF00) >> 8), (byte)((val & 0xFF) >> 0)};
        return data;
    }

    @Deprecated
    public static short toShort(byte[] data) {
        if (data != null && data.length >= 2) {
            return (short)((data[0] & 0xFF) << 8 | data[1] & 0xFF);
        }
        return 0;
    }

    @Deprecated
    public static byte[] toBytes(char[] c) {
        return LessBytes.toUtf16Bytes(c);
    }

    @Deprecated
    public static byte[] toUtf16Bytes(char[] c) {
        byte[] b = new byte[c.length * 2];
        int j = 0;
        for (int i = 0; i < c.length; ++i) {
            b[j] = (byte)(c[i] >> 8 & 0xFF);
            b[j + 1] = (byte)(c[i] & 0xFF);
            j += 2;
        }
        return b;
    }

    @Deprecated
    public static char[] toChars(byte[] b) {
        return LessBytes.toCharsFromUtf16(b);
    }

    @Deprecated
    public static char[] toCharsFromUtf16(byte[] b) {
        char[] c = new char[b.length >> 1];
        int j = 0;
        for (int i = 0; i < c.length; ++i) {
            c[i] = (char)(b[j++] << 8 & 0xFF00 | b[j++] & 0xFF);
        }
        return c;
    }

    @Deprecated
    public static byte[] toBytes(int[] vals) {
        byte[] bytes = new byte[vals.length * 4];
        for (int i = 0; i < vals.length; ++i) {
            byte[] bytesForInt = LessBytes.toBytes(vals[i]);
            System.arraycopy(bytesForInt, 0, bytes, i * 4, bytesForInt.length);
        }
        return bytes;
    }

    @Deprecated
    public static int[] toInts(byte[] b) {
        int[] ints = new int[b.length / 4];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = LessBytes.toInt(b, i * 4, 0);
        }
        return ints;
    }

    @Deprecated
    public static void copy(byte[] source, byte[] target, int offset) {
        System.arraycopy(source, 0, target, offset, source.length);
    }

    @Deprecated
    public static char[] toChars(String s) {
        return s.toCharArray();
    }

    @Deprecated
    public static byte[] toBytes(int val) {
        byte[] data = new byte[]{(byte)((val & 0xFF000000) >> 24), (byte)((val & 0xFF0000) >> 16), (byte)((val & 0xFF00) >> 8), (byte)((val & 0xFF) >> 0)};
        return data;
    }

    @Deprecated
    public static byte[] toBytes(long val) {
        byte[] data = new byte[]{(byte)((val & 0xFF00000000000000L) >> 56), (byte)((val & 0xFF000000000000L) >> 48), (byte)((val & 0xFF0000000000L) >> 40), (byte)((val & 0xFF00000000L) >> 32), (byte)((val & 0xFF000000L) >> 24), (byte)((val & 0xFF0000L) >> 16), (byte)((val & 0xFF00L) >> 8), (byte)((val & 0xFFL) >> 0)};
        return data;
    }

    @Deprecated
    public static int toInt(byte[] data) {
        return LessBytes.toInt(data, 0);
    }

    @Deprecated
    public static int toInt(byte[] data, int defaultValue) {
        return LessBytes.toInt(data, 0, defaultValue);
    }

    @Deprecated
    public static int toInt(byte[] data, int off, int defaultValue) {
        if (data != null && data.length >= off + 4) {
            return (data[off] & 0xFF) << 24 | (data[off + 1] & 0xFF) << 16 | (data[off + 2] & 0xFF) << 8 | data[off + 3] & 0xFF;
        }
        return defaultValue;
    }

    @Deprecated
    public static long toUInt(byte[] data) {
        return LessBytes.toUInt(data, 0L);
    }

    @Deprecated
    public static long toUInt(byte[] data, long def) {
        return LessBytes.toUInt(data, 0, def);
    }

    @Deprecated
    public static long toUInt(byte[] data, int off, long def) {
        if (data != null && data.length >= off + 4) {
            return ((long)data[off] & 0xFFL) << 24 | ((long)data[off + 1] & 0xFFL) << 16 | ((long)data[off + 2] & 0xFFL) << 8 | (long)data[off + 3] & 0xFFL;
        }
        return def;
    }

    @Deprecated
    public static long toLong(byte[] data) {
        return LessBytes.toLong(data, 0L);
    }

    @Deprecated
    public static long toLong(byte[] data, long def) {
        return LessBytes.toLong(data, 0, def);
    }

    @Deprecated
    public static long toLong(byte[] data, int off, long def) {
        if (data != null && data.length >= 8 + off) {
            return ((long)data[off] & 0xFFL) << 56 | ((long)data[off + 1] & 0xFFL) << 48 | ((long)data[off + 2] & 0xFFL) << 40 | ((long)data[off + 3] & 0xFFL) << 32 | ((long)data[off + 4] & 0xFFL) << 24 | ((long)data[off + 5] & 0xFFL) << 16 | ((long)data[off + 6] & 0xFFL) << 8 | (long)data[off + 7] & 0xFFL;
        }
        return def;
    }

    public static void writeLength(long size, OutputStream os) throws IOException {
        if (size < 0L) {
            throw new IllegalArgumentException("writeLength value must be >= 0: " + size);
        }
        if (size == 0L) {
            os.write(0);
            return;
        }
        while (size > 0L) {
            if (size > 127L) {
                os.write((int)(0x80L | size & 0x7FL));
            } else {
                os.write((int)(size & 0x7FL));
            }
            size >>= 7;
        }
    }

    public static long readLength(InputStream in) throws IOException {
        long size = 0L;
        long iter = 0L;
        long next = 0L;
        do {
            if ((next = (long)in.read()) < 0L) {
                throw new EOFException();
            }
            size |= (next & 0x7FL) << (int)iter;
            iter += 7L;
        } while ((next & 0x80L) == 128L);
        return size;
    }

    @Deprecated
    public static short readShort(InputStream in) throws IOException {
        return LessBytes.toShort(LessBytes.readBytes(in, 2));
    }

    @Deprecated
    public static int readInt(InputStream in) throws IOException {
        return LessBytes.toInt(LessBytes.readBytes(in, 4), -1);
    }

    @Deprecated
    public static long readUInt(InputStream in) throws IOException {
        return LessBytes.toUInt(LessBytes.readBytes(in, 4), -1L);
    }

    @Deprecated
    public static long readLong(InputStream in) throws IOException {
        return LessBytes.toLong(LessBytes.readBytes(in, 8), -1L);
    }

    @Deprecated
    public static void writeShort(short s, OutputStream os) throws IOException {
        os.write(LessBytes.toBytes(s));
    }

    @Deprecated
    public static void writeInt(int i, OutputStream os) throws IOException {
        os.write(LessBytes.toBytes(i));
    }

    @Deprecated
    public static void writeLong(long l, OutputStream os) throws IOException {
        os.write(LessBytes.toBytes(l));
    }

    public static void writeBytes(byte[] b, OutputStream os) throws IOException {
        LessBytes.writeLength(b.length, os);
        if (b.length > 0) {
            os.write(b);
        }
    }

    public static void writeBytes(byte[] b, int off, int len, OutputStream os) throws IOException {
        if (len > 0) {
            LessBytes.writeLength(len, os);
            os.write(b, off, len);
        }
    }

    @Deprecated
    public static void writeChars(char[] c, OutputStream os) throws IOException {
        LessBytes.writeBytes(LessBytes.toBytes(c), os);
    }

    @Deprecated
    public static byte[] readFully(InputStream in) throws IOException {
        return ByteStreams.toByteArray((InputStream)in);
    }

    @Deprecated
    public static int writeFully(InputStream is, OutputStream os) throws IOException {
        return (int)ByteStreams.copy((InputStream)is, (OutputStream)os);
    }

    @Nullable
    @Deprecated
    public static byte[] readBytes(InputStream in) throws IOException {
        return LessBytes.readBytes(in, (int)LessBytes.readLength(in));
    }

    @Deprecated
    public static char[] readChars(InputStream in) throws IOException {
        return LessBytes.toChars(LessBytes.readBytes(in, (int)LessBytes.readLength(in)));
    }

    @Nullable
    @Deprecated
    public static byte[] readBytes(InputStream in, int len) throws IOException {
        if (len < 0) {
            return null;
        }
        if (len == 0) {
            return emptyBytes;
        }
        byte[] b = new byte[len];
        ByteStreams.readFully((InputStream)in, (byte[])b);
        return b;
    }

    @Deprecated
    public static void readBytes(InputStream is, byte[] b, int off, int len) throws IOException {
        ByteStreams.readFully((InputStream)is, (byte[])b, (int)off, (int)len);
    }

    @Deprecated
    public static void writeString(String str, OutputStream os) throws IOException {
        LessBytes.writeBytes(str != null ? LessBytes.toBytes(str) : emptyBytes, os);
    }

    @Deprecated
    public static void writeCharString(String str, OutputStream os) throws IOException {
        LessBytes.writeChars(str != null ? str.toCharArray() : new char[]{}, os);
    }

    @Nullable
    @Deprecated
    public static String readString(InputStream in) throws IOException {
        return LessBytes.toString(LessBytes.readBytes(in));
    }

    @Nullable
    @Deprecated
    public static String readString(InputStream in, boolean emptyNull) throws IOException {
        byte[] b = LessBytes.readBytes(in);
        if (b != null) {
            if (b.length > 0) {
                return LessBytes.toString(b);
            }
            return emptyNull ? null : LessBytes.toString(b);
        }
        throw new RuntimeException("Length field was likely negative; possible corruption");
    }

    @Nullable
    @Deprecated
    public static String readCharString(InputStream in) throws IOException {
        char[] ch = LessBytes.readChars(in);
        if (ch != null) {
            return new String(ch);
        }
        return null;
    }

    @Deprecated
    public static String urlencode(String s) {
        if (nativeURLCodec) {
            try {
                return URLEncoder.encode(s, "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return UrlEscapers.urlFormParameterEscaper().escape(s);
    }

    @Nullable
    @Deprecated
    public static String urldecode(String s) {
        if (s == null || !s.contains("%") && !s.contains("+")) {
            return s;
        }
        if (nativeURLCodec) {
            try {
                return URLDecoder.decode(s, "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        byte[] c = LessBytes.toBytes(s);
        int vcount = 0;
        boolean changed = false;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == 37 && i < c.length - 2) {
                if (LessBytes.hex2dec(c[i + 1]) < 0 || LessBytes.hex2dec(c[i + 2]) < 0) continue;
                ++vcount;
                continue;
            }
            if (c[i] != 43) continue;
            c[i] = 32;
            changed = true;
        }
        if (vcount > 0) {
            int pos = 0;
            byte[] nc = new byte[c.length - vcount * 2];
            for (int i = 0; i < c.length; ++i) {
                if (c[i] == 37 && i < c.length - 2) {
                    int hd1 = LessBytes.hex2dec(c[i + 1]);
                    int hd2 = LessBytes.hex2dec(c[i + 2]);
                    if (hd1 >= 0 && hd2 >= 0) {
                        nc[pos++] = (byte)((hd1 << 4 | hd2) & 0xFF);
                        i += 2;
                        continue;
                    }
                    nc[pos++] = c[i];
                    continue;
                }
                nc[pos++] = c[i] == 43 ? 32 : c[i];
            }
            return new String(nc, 0, pos, UTF8);
        }
        if (changed) {
            return new String(c, UTF8);
        }
        return s;
    }

    @Deprecated
    public static int hex2dec(char c) {
        if ((c = (char)(c | 0x20)) >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        return -1;
    }

    @Deprecated
    public static int hex2dec(byte c) {
        if ((c = (byte)(c | 0x20)) >= 97 && c <= 102) {
            return 10 + (c - 97);
        }
        if (c >= 65 && c <= 70) {
            return 10 + (c - 65);
        }
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        return -1;
    }

    public static int reverseBits(int v1) {
        return BitReverseTable256[v1 & 0xFF] << 24 | BitReverseTable256[v1 >> 8 & 0xFF] << 16 | BitReverseTable256[v1 >> 16 & 0xFF] << 8 | BitReverseTable256[v1 >> 24 & 0xFF];
    }

    public static long reverseBits(long v1) {
        return (long)BitReverseTable256[(int)v1 & 0xFF] << 56 | (long)BitReverseTable256[(int)(v1 >> 8) & 0xFF] << 48 | (long)BitReverseTable256[(int)(v1 >> 16) & 0xFF] << 40 | (long)BitReverseTable256[(int)(v1 >> 24) & 0xFF] << 32 | (long)BitReverseTable256[(int)(v1 >> 32) & 0xFF] << 24 | (long)BitReverseTable256[(int)(v1 >> 40) & 0xFF] << 16 | (long)BitReverseTable256[(int)(v1 >> 48) & 0xFF] << 8 | (long)BitReverseTable256[(int)(v1 >> 56) & 0xFF];
    }

    @Deprecated
    public static int compare(byte[] a, byte[] b) {
        return UnsignedBytes.lexicographicalComparator().compare(a, b);
    }

    @Deprecated
    public static boolean equals(byte[] a, byte[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean isEmpty(byte[] arr) {
        return arr == null || arr.length == 0;
    }

    @Deprecated
    public static byte[] cut(byte[] src, int off, int len) {
        return Arrays.copyOfRange(src, off, off + len);
    }

    @Deprecated
    public static String clear(String s, char ch) {
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            c[i] = ch;
        }
        return new String(c);
    }

    @Deprecated
    public static String pad0(long val, int zeros) {
        String sval = Long.toString(val);
        return Strings.padStart((String)sval, (int)zeros, (char)'0');
    }
}

