/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.util;

import com.addthis.basis.util.CUID;
import com.addthis.basis.util.LessBytes;
import com.addthis.basis.util.Parameter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public final class LessFiles {
    private static final boolean useStackTraceTempDirname = Parameter.boolValue("debug.tempdir.stacktrace", false);

    private LessFiles() {
    }

    public static boolean deleteDir(File dir) {
        boolean rval = true;
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                rval = rval && LessFiles.deleteDir(child);
            }
        }
        return rval && dir.delete();
    }

    public static boolean flushDir(File dir) {
        boolean rval = true;
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                rval = rval && LessFiles.deleteDir(child);
            }
        }
        return rval;
    }

    public static void write(String path, byte[] data, boolean append) throws IOException {
        File f = new File(path);
        LessFiles.write(f, data, append);
    }

    public static void write(File out, byte[] data, boolean append) throws IOException {
        try (FileOutputStream fot = new FileOutputStream(out, append);){
            fot.write(data);
        }
    }

    public static byte[] read(File in) throws IOException {
        try (FileInputStream fin = new FileInputStream(in);){
            byte[] byArray = LessBytes.readFully(fin);
            return byArray;
        }
    }

    public static File createTempDir() throws IOException {
        StackTraceElement[] stack;
        String prefix = "ctd";
        if (useStackTraceTempDirname && (stack = Thread.currentThread().getStackTrace()).length > 2) {
            prefix = stack[2].getClassName() + "." + stack[2].getMethodName();
        }
        return LessFiles.createTempDir(prefix, "tmp");
    }

    public static File createTempDir(String prefix, String suffix) throws IOException {
        File tmp = File.createTempFile(prefix, suffix);
        tmp.delete();
        tmp.mkdirs();
        return tmp;
    }

    public static boolean isFileReadable(String filename) {
        boolean isReadable = false;
        try {
            File file = new File(filename);
            isReadable = file.canRead();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isReadable;
    }

    public static BufferedReader getReader(String filepath) throws IOException {
        return LessFiles.getReader(new File(filepath));
    }

    public static BufferedReader getReader(File file) throws IOException {
        return new BufferedReader(new FileReader(file));
    }

    public static BufferedReader getReader(InputStream is) {
        return new BufferedReader(new InputStreamReader(is));
    }

    public static File initDirectory(String dir) {
        return LessFiles.initDirectory(new File(dir));
    }

    public static File initDirectory(File file) {
        if (file.isDirectory()) {
            return file;
        }
        if (file.isFile()) {
            throw new RuntimeException("Requested directory '" + file + "' is a file");
        }
        if (!file.mkdirs()) {
            throw new RuntimeException("Unable to create directory '" + file + "'");
        }
        return file;
    }

    public static File openDirectory(File file) throws IOException {
        if (file.isDirectory()) {
            return file;
        }
        if (file.isFile()) {
            throw new IOException("Requested directory '" + file + "' is a file");
        }
        if (!file.mkdirs()) {
            throw new IOException("Unable to create directory '" + file + "'");
        }
        return file;
    }

    public static String setupUIDFile(File dir, String uidFileName) throws IOException {
        Throwable throwable;
        File uid = new File(dir, uidFileName);
        String guid = CUID.createCUID();
        if (uid.exists() && uid.isFile() && uid.canRead()) {
            throwable = null;
            try (FileReader fr = new FileReader(uid);){
                BufferedReader br = new BufferedReader(fr);
                guid = br.readLine();
                if (guid == null || guid.trim().isEmpty()) {
                    guid = CUID.createCUID();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        throwable = null;
        try (FileOutputStream fos = new FileOutputStream(uid);){
            fos.write(guid.getBytes());
            fos.flush();
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        return guid;
    }

    public static void truncate(File file, long size) throws IOException {
        if (file == null) {
            return;
        }
        if (size > file.length()) {
            throw new IllegalArgumentException("file " + file.getName() + " cannot be truncated, desired size (" + size + ") is greater than file length.");
        }
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            raf.setLength(size);
        }
    }

    public static void expandPath(String root, List<File> expanded) {
        int off = 0;
        off = root.indexOf("/*");
        if (off >= 0) {
            String left = root.substring(0, off);
            String right = off + 3 < root.length() ? root.substring(off + 3, root.length()) : "";
            File dir = new File(left);
            if (dir.exists() && dir.isDirectory()) {
                File[] files;
                for (File file : files = dir.listFiles()) {
                    LessFiles.expandPath(left + "/" + file.getName() + "/" + right, expanded);
                }
            }
        } else {
            expanded.add(new File(root));
        }
    }

    public static File[] matchFiles(String dirTemplate) {
        ArrayList<File> expanded = new ArrayList<File>();
        LessFiles.expandPath(dirTemplate, expanded);
        return expanded.toArray(new File[expanded.size()]);
    }

    public static String getSuffix(File file) {
        return LessFiles.getSuffix(file.getName());
    }

    public static String getSuffix(String fname) {
        int suffix_pos = fname.lastIndexOf(46);
        if (suffix_pos == -1) {
            return "";
        }
        return fname.substring(1 + suffix_pos);
    }

    public static File replaceSuffix(File file, String new_suffix) {
        String name = file.getName();
        int suffix_pos = name.lastIndexOf(46);
        return new File(file.getParent(), suffix_pos == -1 ? name + new_suffix : name.substring(0, suffix_pos) + new_suffix);
    }
}

