/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.util;

import com.addthis.basis.util.LessBytes;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.math.BigInteger;
import java.util.Random;
import java.util.UUID;

public class LessNumbers {
    private static final HashFunction fallbackHashFunc;
    private static final long SIX_BIT_MASK = 63L;
    static final char[] basechars;
    static final BigInteger[] bigIntegerChars;
    public static final int MAX_BASE;
    private static final String[] pads;
    public static final Random random;
    public static final byte[] hex;
    public static final byte[] HEX;
    private static final boolean verboseHex;

    public static long parseHumanReadable(String num) {
        if ((num = num.toUpperCase()).endsWith("M") || num.endsWith("MB")) {
            return Long.parseLong(num.substring(0, num.indexOf("M"))) * 1024L * 1024L;
        }
        if (num.endsWith("MIB")) {
            return Long.parseLong(num.substring(0, num.indexOf("M"))) * 1000L * 1000L;
        }
        if (num.endsWith("K") || num.endsWith("KB")) {
            return Long.parseLong(num.substring(0, num.indexOf("K"))) * 1024L;
        }
        if (num.endsWith("KIB")) {
            return Long.parseLong(num.substring(0, num.indexOf("K"))) * 1000L;
        }
        if (num.endsWith("G") || num.endsWith("GB")) {
            return Long.parseLong(num.substring(0, num.indexOf("G"))) * 1024L * 1024L * 1024L;
        }
        if (num.endsWith("GIB")) {
            return Long.parseLong(num.substring(0, num.indexOf("G"))) * 1000L * 1000L * 1000L;
        }
        return Long.parseLong(num);
    }

    public static int parseInt(String val, int def, int radix) {
        try {
            return Integer.parseInt(val, radix);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static long parseLong(String val, long def, int radix) {
        try {
            return Long.parseLong(val, radix);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static float parseFloat(String val, float def) {
        try {
            return Float.parseFloat(val);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static double parseDouble(String val, double def) {
        try {
            return Double.parseDouble(val);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static long longFromBase(String val, int base) {
        return LessNumbers.longFromBase(val, base, false);
    }

    public static long longFromBase(String val, int base, boolean fallback) {
        char[] cv;
        if (base > basechars.length) {
            if (fallback) {
                return fallbackHashFunc.hashUnencodedChars((CharSequence)val).asLong();
            }
            throw new RuntimeException(base + " outside base range of 2-" + basechars.length);
        }
        long rv = 0L;
        for (char aCv : cv = val.toCharArray()) {
            rv *= (long)base;
            int av = 0;
            if (aCv >= '0' && aCv <= '9') {
                av = aCv - 48;
            } else if (aCv >= 'a' && aCv <= 'z') {
                av = aCv - 97 + 10;
            } else if (aCv >= 'A' && aCv <= 'Z') {
                av = aCv - 65 + 36;
            } else {
                if (fallback) {
                    return fallbackHashFunc.hashUnencodedChars((CharSequence)val).asLong();
                }
                throw new RuntimeException("invalid base encoding: " + val);
            }
            if (av >= base) {
                if (fallback) {
                    return fallbackHashFunc.hashUnencodedChars((CharSequence)val).asLong();
                }
                throw new RuntimeException("chars outside of base range: " + val);
            }
            rv += (long)av;
        }
        return rv;
    }

    public static int intFromBase(String val, int base) {
        char[] cv;
        if (base > basechars.length) {
            throw new RuntimeException(base + " outside base range of 2-" + basechars.length);
        }
        int rv = 0;
        for (char aCv : cv = val.toCharArray()) {
            rv *= base;
            if (aCv >= '0' && aCv <= '9') {
                rv += aCv - 48;
                continue;
            }
            if (aCv >= 'a' && aCv <= 'z') {
                rv += aCv - 97 + 10;
                continue;
            }
            if (aCv >= 'A' && aCv <= 'Z') {
                rv += aCv - 65 + 36;
                continue;
            }
            throw new RuntimeException("invalid base encoding: " + val);
        }
        return rv;
    }

    public static String toBase(long val, int base) {
        return LessNumbers.toBase(val, base, -1);
    }

    public static String toBase(long val, int base, int minlen) {
        if (base > basechars.length) {
            throw new RuntimeException(base + " outside base range of 2-" + basechars.length);
        }
        char[] out = new char[128];
        int i = out.length - 1;
        while (true) {
            out[i] = basechars[(int)Math.abs(val % (long)base)];
            if (--minlen <= 0 && ((val /= (long)base) == 0L || i == 0)) {
                return new String(out, i, out.length - i);
            }
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String nextLong(int base) {
        String[] stringArray = pads;
        synchronized (pads) {
            String pad = pads[base - 1];
            if (pad == null) {
                LessNumbers.pads[base - 1] = pad = LessBytes.clear(LessNumbers.toBase(Long.MAX_VALUE, base), '0');
            }
            String nv = LessNumbers.toBase(random.nextLong(), base);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return pad.substring(nv.length()) + nv;
        }
    }

    public static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (byte c : b) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            char c1 = (char)hex[c >> 4 & 0xF];
            char c2 = (char)hex[c & 0xF];
            sb.append(c1);
            sb.append(c2);
            if (!verboseHex) continue;
            sb.append(' ');
            if (c >= 32 && c <= 126) {
                sb.append((char)c);
                continue;
            }
            sb.append('.');
        }
        return sb.toString();
    }

    public static int parseInt(int radix, String val, int def) {
        try {
            return Integer.parseInt(val, radix);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static long parseLong(int radix, String val, long def) {
        try {
            return Long.parseLong(val, radix);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static long longFromBase36(String val) {
        return LessNumbers.longFromBase(val.toLowerCase(), 36);
    }

    public static long longFromBase64(String val) {
        return LessNumbers.longFromBase(val, 64);
    }

    public static String toBase36(long val) {
        return LessNumbers.toBase(val, 36).toUpperCase();
    }

    public static int intFromBase36(String val) {
        return LessNumbers.intFromBase(val.toLowerCase(), 36);
    }

    public static String toBase64(long val) {
        return LessNumbers.toBase(val, 64);
    }

    public static int intFromBase64(String val) {
        return LessNumbers.intFromBase(val, 64);
    }

    static int charToDigit(char character, String val) {
        if (character >= '0' && character <= '9') {
            return character - 48;
        }
        if (character >= 'a' && character <= 'z') {
            return character - 97 + 10;
        }
        if (character >= 'A' && character <= 'Z') {
            return character - 65 + 36;
        }
        if (character == '-') {
            return 62;
        }
        if (character == '_') {
            return 63;
        }
        throw new RuntimeException("invalid base encoding: " + val);
    }

    public static BigInteger bigIntegerFromBase(String val, int base) {
        if (base > MAX_BASE) {
            throw new RuntimeException(base + " outside base range of 2-" + MAX_BASE);
        }
        BigInteger rv = BigInteger.ZERO;
        BigInteger biBase = BigInteger.valueOf(base);
        char[] cv = val.toCharArray();
        for (int i = 0; i < cv.length; ++i) {
            rv = rv.multiply(biBase);
            char cvv = cv[i];
            if (cvv >= '0' && cvv <= '9') {
                rv = rv.add(bigIntegerChars[cvv - 48]);
                continue;
            }
            if (cvv >= 'a' && cvv <= 'z') {
                rv = rv.add(bigIntegerChars[cvv - 97 + 10]);
                continue;
            }
            if (cvv >= 'A' && cvv <= 'Z') {
                rv = rv.add(bigIntegerChars[cvv - 65 + 36]);
                continue;
            }
            if (cvv == '-') {
                rv = rv.add(bigIntegerChars[62]);
                continue;
            }
            if (cvv == '_') {
                rv = rv.add(bigIntegerChars[63]);
                continue;
            }
            throw new RuntimeException("invalid base encoding: " + val);
        }
        return rv;
    }

    public static UUID UUIDFromBase64(String val) {
        char[] cv = val.toCharArray();
        long hiBits = 0L;
        int pos = 0;
        for (int i = 0; i < 11; ++i) {
            hiBits <<= 6;
            hiBits += (long)LessNumbers.charToDigit(cv[pos++], val);
        }
        int mixBits = LessNumbers.charToDigit(cv[pos++], val);
        hiBits <<= 2;
        hiBits += (long)(mixBits >>> 4);
        long loBits = mixBits;
        for (int i = 0; i < 10; ++i) {
            loBits <<= 6;
            loBits += (long)LessNumbers.charToDigit(cv[pos++], val);
        }
        return new UUID(hiBits, loBits);
    }

    public static String toBase(BigInteger val, int base) {
        return LessNumbers.toBase(val, base, -1);
    }

    public static String toBase(BigInteger val, int base, int minlen) {
        if (base > MAX_BASE) {
            throw new RuntimeException(base + " outside base range of 2-" + MAX_BASE);
        }
        char[] out = new char[128];
        BigInteger biBase = BigInteger.valueOf(base);
        int i = out.length - 1;
        while (true) {
            BigInteger[] divAndRem = val.divideAndRemainder(biBase);
            out[i] = basechars[Math.abs(divAndRem[1].intValue())];
            val = divAndRem[0];
            if (--minlen <= 0 && (val.equals(BigInteger.ZERO) || i == 0)) {
                return new String(out, i, out.length - i);
            }
            --i;
        }
    }

    public static String toBase64(UUID val) {
        long hiBits = val.getMostSignificantBits();
        long loBits = val.getLeastSignificantBits();
        char[] out = new char[22];
        int pos = 21;
        for (int i = 0; i < 10; ++i) {
            out[pos--] = basechars[(int)(loBits & 0x3FL)];
            loBits >>>= 6;
        }
        int mixBits = (int)(hiBits & 3L) << 4 | (int)loBits;
        out[pos--] = basechars[mixBits];
        hiBits >>>= 2;
        for (int i = 0; i < 11; ++i) {
            out[pos--] = basechars[(int)(hiBits & 0x3FL)];
            hiBits >>>= 6;
        }
        return new String(out);
    }

    public static String toBase36(BigInteger val) {
        return LessNumbers.toBase(val, 36).toUpperCase();
    }

    public static BigInteger bigIntegerFromBase36(String val) {
        return LessNumbers.bigIntegerFromBase(val.toLowerCase(), 36);
    }

    public static String toBase64(BigInteger val) {
        return LessNumbers.toBase(val, 64);
    }

    public static BigInteger bigIntegerFromBase64(String val) {
        return LessNumbers.bigIntegerFromBase(val, 64);
    }

    static {
        int i;
        fallbackHashFunc = Hashing.murmur3_128();
        basechars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_".toCharArray();
        bigIntegerChars = new BigInteger[basechars.length];
        int offset = 0;
        for (i = 48; i <= 57; i = (int)((char)(i + 1))) {
            LessNumbers.bigIntegerChars[offset++] = BigInteger.valueOf(i - 48);
        }
        for (i = 97; i <= 122; i = (int)((char)(i + 1))) {
            LessNumbers.bigIntegerChars[offset++] = BigInteger.valueOf(i - 97 + 10);
        }
        for (i = 65; i <= 90; i = (int)((char)(i + 1))) {
            LessNumbers.bigIntegerChars[offset++] = BigInteger.valueOf(i - 65 + 36);
        }
        LessNumbers.bigIntegerChars[offset++] = BigInteger.valueOf(62L);
        LessNumbers.bigIntegerChars[offset++] = BigInteger.valueOf(63L);
        MAX_BASE = basechars.length;
        pads = new String[MAX_BASE];
        random = new Random(System.currentTimeMillis());
        hex = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        verboseHex = System.getProperty("xhex", "0").equals("1");
    }
}

