/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MemoryCounter {
    private static final ConcurrentHashMap<Class<?>, FieldCache[]> fieldCache = new ConcurrentHashMap();
    private static final Map<Class<?>, MemEstimator> estimators = new IdentityHashMap();
    private static Instrumentation instrumentation;
    private static final int booleanClass;
    private static final int byteClass;
    private static final int charClass;
    private static final int shortClass;
    private static final int intClass;
    private static final int floatClass;
    private static final int doubleClass;
    private static final int longClass;
    private final Map<Object, Object> visited = new IdentityHashMap<Object, Object>();
    private final LinkedList<Object> stack = new LinkedList();

    public static void premain(String args, Instrumentation inst) {
        System.out.println("using native jvm instrumentation: " + inst);
        instrumentation = inst;
    }

    public static void registerEstimator(Class<?> clazz, MemEstimator est) {
        estimators.put(clazz, est);
    }

    public static long estimateSize(Object o) {
        return new MemoryCounter().estimate(o);
    }

    private long estimate(Object obj) {
        long result = this._estimate(obj);
        while (!this.stack.isEmpty()) {
            result += this._estimate(this.stack.pop());
        }
        return result;
    }

    private boolean skipObject(Object obj) {
        return obj == null || this.visited.containsKey(obj);
    }

    private static FieldCache[] getFieldCache(Class<?> clazz) {
        FieldCache[] fields = fieldCache.get(clazz);
        if (fields == null) {
            Field[] rawfields = clazz.getDeclaredFields();
            ArrayList<FieldCache> list = new ArrayList<FieldCache>(rawfields.length);
            for (Field rawfield : rawfields) {
                if (Modifier.isStatic(rawfield.getModifiers()) || rawfield.isSynthetic()) continue;
                FieldCache cachedField = new FieldCache();
                cachedField.field = rawfield;
                if (cachedField.field.getType().isPrimitive()) {
                    cachedField.primitive = MemoryCounter.getPrimitiveFieldSize(cachedField.field.getType());
                } else {
                    cachedField.policy = cachedField.field.getAnnotation(Mem.class);
                    cachedField.field.setAccessible(true);
                }
                list.add(cachedField);
            }
            fields = list.toArray(new FieldCache[list.size()]);
            fieldCache.put(clazz, fields);
        }
        return fields;
    }

    private long _estimate(Object obj) {
        if (this.skipObject(obj)) {
            return 0L;
        }
        this.visited.put(obj, null);
        long result = 0L;
        Class<?> clazz = obj.getClass();
        if (clazz.isArray()) {
            return this._estimateArray(obj);
        }
        if (clazz == Thread.class || clazz == ThreadGroup.class) {
            System.err.println("estimator rejecting " + clazz + " = " + obj);
            return 0L;
        }
        MemEstimator est = estimators.get(clazz);
        if (est != null) {
            return this.roundUpToNearestEightBytes(est.getMemorySize(obj));
        }
        if (instrumentation != null) {
            result = instrumentation.getObjectSize(obj);
        }
        while (clazz != null) {
            FieldCache[] fields;
            for (FieldCache field : fields = MemoryCounter.getFieldCache(clazz)) {
                if (field.primitive > 0) {
                    if (instrumentation != null) continue;
                    result += (long)field.primitive;
                    continue;
                }
                Annotation policy = field.policy;
                if (policy != null) {
                    Mem mp = (Mem)policy;
                    if (mp.size() >= 0) {
                        result += (long)mp.size();
                        continue;
                    }
                    if (!mp.estimate()) continue;
                }
                if (instrumentation == null) {
                    result += (long)MemoryCounter.getPointerSize();
                }
                try {
                    Object toBeDone = field.field.get(obj);
                    if (toBeDone == null) continue;
                    this.stack.add(toBeDone);
                }
                catch (IllegalAccessException ex) {
                    assert (false);
                }
            }
            clazz = clazz.getSuperclass();
        }
        return this.roundUpToNearestEightBytes(result + (long)MemoryCounter.getClassSize());
    }

    private long roundUpToNearestEightBytes(long result) {
        long mod = result % 8L;
        if (mod != 0L) {
            result += 8L - mod;
        }
        return result;
    }

    private long _estimateArray(Object obj) {
        long result = 16L;
        int length = Array.getLength(obj);
        if (length != 0) {
            Class<?> arrayElementClazz = obj.getClass().getComponentType();
            if (arrayElementClazz.isPrimitive()) {
                result += (long)(length * MemoryCounter.getPrimitiveArrayElementSize(arrayElementClazz));
            } else {
                for (int i = 0; i < length; ++i) {
                    result += (long)MemoryCounter.getPointerSize() + this._estimate(Array.get(obj, i));
                }
            }
        }
        return result;
    }

    private static int getPrimitiveFieldSize(Class<?> clazz) {
        int hc = clazz.hashCode();
        if (hc == booleanClass) {
            return 1;
        }
        if (hc == byteClass) {
            return 1;
        }
        if (hc == charClass) {
            return 2;
        }
        if (hc == shortClass) {
            return 2;
        }
        if (hc == intClass) {
            return 4;
        }
        if (hc == floatClass) {
            return 4;
        }
        if (hc == doubleClass) {
            return 8;
        }
        if (hc == longClass) {
            return 8;
        }
        return 0;
    }

    private static int getPrimitiveArrayElementSize(Class<?> clazz) {
        return MemoryCounter.getPrimitiveFieldSize(clazz);
    }

    private static int getPointerSize() {
        return 4;
    }

    private static int getClassSize() {
        return 8;
    }

    static {
        booleanClass = Boolean.TYPE.hashCode();
        byteClass = Byte.TYPE.hashCode();
        charClass = Character.TYPE.hashCode();
        shortClass = Short.TYPE.hashCode();
        intClass = Integer.TYPE.hashCode();
        floatClass = Float.TYPE.hashCode();
        doubleClass = Double.TYPE.hashCode();
        longClass = Long.TYPE.hashCode();
        MemoryCounter.registerEstimator(String.class, new StringEstimator());
    }

    private static final class FieldCache {
        private Field field;
        private int primitive;
        private Annotation policy;

        private FieldCache() {
        }
    }

    public static class StringEstimator
    implements MemEstimator {
        private static final long base_size = MemoryCounter.estimateSize(new String(""));

        @Override
        public long getMemorySize(Object object) {
            return base_size + (long)(((String)object).length() * 2);
        }
    }

    public static interface MemEstimator {
        public long getMemorySize(Object var1);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Mem {
        public boolean estimate() default true;

        public int size() default -1;
    }
}

