/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.util;

import com.addthis.basis.util.LessStrings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class Meter<E extends Enum<E>> {
    private Counter[] counters;
    private Metric[] metrics;

    public Meter(E[] counters) {
        int i;
        this.counters = new Counter[counters.length];
        for (i = 0; i < counters.length; ++i) {
            this.counters[i] = new Counter();
        }
        this.metrics = new Metric[this.counters.length];
        for (i = 0; i < this.metrics.length; ++i) {
            this.metrics[i] = new Metric();
        }
    }

    public Meter<E> addCountMetric(E which, String label) {
        this.metrics[((Enum)which).ordinal()].setCountLabel(label);
        return this;
    }

    public Meter<E> addCountMetric(E which) {
        return this.addCountMetric(which, ((Enum)which).toString());
    }

    public Meter<E> addMaxMetric(E which, String label) {
        this.metrics[((Enum)which).ordinal()].setMaxLabel(label);
        return this;
    }

    public Meter<E> addMaxMetric(E which) {
        return this.addMaxMetric(which, ((Enum)which).toString());
    }

    public Meter<E> addAverageMetric(E which, String label) {
        this.metrics[((Enum)which).ordinal()].setAverageLabel(label);
        return this;
    }

    public Meter<E> addAverageMetric(E which) {
        return this.addAverageMetric(which, ((Enum)which).toString());
    }

    public Meter<E> addRateMetric(E which, String label) {
        this.metrics[((Enum)which).ordinal()].setRateLabel(label);
        return this;
    }

    public Meter<E> addRateMetric(E which) {
        return this.addRateMetric(which, ((Enum)which).toString());
    }

    public void inc(E which) {
        this.counters[((Enum)which).ordinal()].add(1L);
    }

    public void inc(E which, long val) {
        this.counters[((Enum)which).ordinal()].add(val);
    }

    public long getCount(E which) {
        return this.counters[((Enum)which).ordinal()].get().getCount();
    }

    public long getAverage(E which) {
        return this.counters[((Enum)which).ordinal()].get().getAverage();
    }

    public double getRate(E which) {
        return this.counters[((Enum)which).ordinal()].get().getRate();
    }

    public void reset(E which) {
        this.counters[((Enum)which).ordinal()].mark();
    }

    public Map<String, Long> peek() {
        CounterState[] states = new CounterState[this.counters.length];
        for (int i = 0; i < this.counters.length; ++i) {
            states[i] = this.counters[i].get();
        }
        return this.buildViews(states);
    }

    public Map<String, Long> mark() {
        CounterState[] states = new CounterState[this.counters.length];
        for (int i = 0; i < this.counters.length; ++i) {
            states[i] = this.counters[i].mark();
        }
        return this.buildViews(states);
    }

    private Map<String, Long> buildViews(CounterState[] states) {
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        for (int i = 0; i < this.metrics.length; ++i) {
            if (this.metrics[i] == null) continue;
            if (!LessStrings.isEmpty(this.metrics[i].getCountLabel())) {
                result.put(this.metrics[i].getCountLabel(), states[i].getCount());
            }
            if (!LessStrings.isEmpty(this.metrics[i].getMaxLabel())) {
                result.put(this.metrics[i].getMaxLabel(), states[i].getMax());
            }
            if (!LessStrings.isEmpty(this.metrics[i].getAverageLabel())) {
                result.put(this.metrics[i].getAverageLabel(), states[i].getAverage());
            }
            if (LessStrings.isEmpty(this.metrics[i].getRateLabel())) continue;
            result.put(this.metrics[i].getRateLabel(), (long)states[i].getRate());
        }
        return result;
    }

    private static class Metric {
        private String countLabel;
        private String maxLabel;
        private String averageLabel;
        private String rateLabel;

        public Metric() {
        }

        public Metric(String countLabel, String maxLabel, String averageLabel, String rateLabel) {
            this.countLabel = countLabel;
            this.maxLabel = maxLabel;
            this.averageLabel = averageLabel;
            this.rateLabel = rateLabel;
        }

        public String getCountLabel() {
            return this.countLabel;
        }

        public String getMaxLabel() {
            return this.maxLabel;
        }

        public String getAverageLabel() {
            return this.averageLabel;
        }

        public String getRateLabel() {
            return this.rateLabel;
        }

        public void setCountLabel(String countLabel) {
            this.countLabel = countLabel;
        }

        public void setMaxLabel(String maxLabel) {
            this.maxLabel = maxLabel;
        }

        public void setAverageLabel(String averageLabel) {
            this.averageLabel = averageLabel;
        }

        public void setRateLabel(String rateLabel) {
            this.rateLabel = rateLabel;
        }
    }

    private static class CounterState {
        private final long count;
        private final long max;
        private final long puts;
        private final long intervalms;

        public CounterState(long count, long max, long puts, long intervalms) {
            this.count = count;
            this.max = max;
            this.puts = puts;
            this.intervalms = intervalms;
        }

        public long getCount() {
            return this.count;
        }

        public long getMax() {
            return this.max;
        }

        public long getAverage() {
            return this.puts == 0L ? 0L : this.count / this.puts;
        }

        public double getRate() {
            return this.intervalms == 0L ? 0.0 : (double)this.count * 1000.0 / (double)this.intervalms;
        }
    }

    private static class Counter {
        private AtomicLong count = new AtomicLong();
        private AtomicLong max = new AtomicLong();
        private AtomicLong puts = new AtomicLong();
        private AtomicLong timestamp = new AtomicLong(System.currentTimeMillis());

        public void add(long val) {
            this.count.addAndGet(val);
            if (val > this.max.get()) {
                this.max.set(val);
            }
            this.puts.incrementAndGet();
        }

        public CounterState get() {
            return new CounterState(this.count.get(), this.max.get(), this.puts.get(), System.currentTimeMillis() - this.timestamp.get());
        }

        public CounterState mark() {
            long now = System.currentTimeMillis();
            return new CounterState(this.count.getAndSet(0L), this.max.getAndSet(0L), this.puts.getAndSet(0L), now - this.timestamp.getAndSet(now));
        }
    }
}

