/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.util;

import com.addthis.basis.util.Dict;
import com.addthis.basis.util.MultidictUtil;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class Multidict {
    private Multimap<String, String> map;

    public Multidict() {
        this.map = LinkedHashMultimap.create();
    }

    public Multidict(Multimap<String, String> map) {
        assert (map != null);
        this.map = map;
    }

    public Multidict(Multidict copyme) {
        assert (copyme != null);
        this.map = LinkedHashMultimap.create(copyme.map);
    }

    public Multidict(String query) {
        this.map = MultidictUtil.parse(query);
    }

    public Multidict(String key, String value) {
        this();
        this.map.put((Object)key, (Object)value);
    }

    public boolean put(String key, String ... values) {
        return this.map.putAll((Object)key, Arrays.asList(values));
    }

    public boolean put(String key, int value) {
        return this.map.put((Object)key, (Object)String.valueOf(value));
    }

    public boolean put(String key, long value) {
        return this.map.put((Object)key, (Object)String.valueOf(value));
    }

    public boolean put(String key, double value) {
        return this.map.put((Object)key, (Object)String.valueOf(value));
    }

    public boolean put(String key, float value) {
        return this.map.put((Object)key, (Object)String.valueOf(value));
    }

    public boolean put(String key, boolean value) {
        return this.map.put((Object)key, (Object)String.valueOf(value));
    }

    public <T extends Enum<T>> boolean put(String key, T value) {
        return this.map.put((Object)key, (Object)String.valueOf(value));
    }

    public <T extends Enum<T>> boolean put(T value) {
        if (value == null) {
            return false;
        }
        return this.map.put((Object)value.getClass().getSimpleName().toLowerCase(), (Object)String.valueOf(value));
    }

    public boolean putAll(Multidict multidict) {
        return this.map.putAll(multidict.map);
    }

    public boolean set(String key, String value) {
        boolean had = this.containsKey(key);
        if (this.containsKey(key)) {
            this.map.removeAll((Object)key);
        }
        this.map.put((Object)key, (Object)value);
        return had;
    }

    public boolean set(String key, int value) {
        boolean had = this.containsKey(key);
        if (this.containsKey(key)) {
            this.map.removeAll((Object)key);
        }
        this.map.put((Object)key, (Object)String.valueOf(value));
        return had;
    }

    public boolean set(String key, long value) {
        boolean had = this.containsKey(key);
        if (this.containsKey(key)) {
            this.map.removeAll((Object)key);
        }
        this.map.put((Object)key, (Object)String.valueOf(value));
        return had;
    }

    public boolean set(String key, double value) {
        boolean had = this.containsKey(key);
        if (this.containsKey(key)) {
            this.map.removeAll((Object)key);
        }
        this.map.put((Object)key, (Object)String.valueOf(value));
        return had;
    }

    public boolean set(String key, float value) {
        boolean had = this.containsKey(key);
        if (this.containsKey(key)) {
            this.map.removeAll((Object)key);
        }
        this.map.put((Object)key, (Object)String.valueOf(value));
        return had;
    }

    public boolean set(String key, boolean value) {
        boolean had = this.containsKey(key);
        if (this.containsKey(key)) {
            this.map.removeAll((Object)key);
        }
        this.map.put((Object)key, (Object)String.valueOf(value));
        return had;
    }

    public boolean containsKey(String key) {
        return this.map.containsKey((Object)key);
    }

    public Collection<String> removeAll(String key) {
        return this.map.removeAll((Object)key);
    }

    public String get(String key) {
        return this.containsKey(key) ? (String)this.map.get((Object)key).iterator().next() : null;
    }

    public String get(String key, String dflt) {
        return this.containsKey(key) ? (String)this.map.get((Object)key).iterator().next() : dflt;
    }

    public Collection<String> getAll(String key) {
        return this.map.get((Object)key);
    }

    public Collection<String> getAll(String key, String dflt) {
        return this.containsKey(key) ? this.map.get((Object)key) : Collections.singleton(dflt);
    }

    public int getInt(String key, int dflt) {
        try {
            return this.containsKey(key) ? Integer.parseInt(this.get(key)) : dflt;
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public long getLong(String key, long dflt) {
        try {
            return this.containsKey(key) ? Long.parseLong(this.get(key)) : dflt;
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public float getFloat(String key, float dflt) {
        try {
            return this.containsKey(key) ? Float.parseFloat(this.get(key)) : dflt;
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public double getDouble(String key, double dflt) {
        try {
            return this.containsKey(key) ? Double.parseDouble(this.get(key)) : dflt;
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public boolean getBoolean(String key, boolean dflt) {
        try {
            return this.containsKey(key) ? Boolean.parseBoolean(this.get(key)) : dflt;
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public String toString() {
        return MultidictUtil.toString(this.map);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Multidict)) {
            return false;
        }
        Multidict that = (Multidict)obj;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public int size() {
        return this.map.size();
    }

    public Collection<Map.Entry<String, String>> entries() {
        return this.map.entries();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public Dict asDict() {
        return MultidictUtil.asDict(this);
    }
}

