/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.util;

import com.addthis.basis.util.Dict;
import com.addthis.basis.util.LessStrings;
import com.addthis.basis.util.Multidict;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;

public class MultidictUtil {
    public static Multimap<String, String> parse(String query) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        return MultidictUtil.parse(query, (Multimap<String, String>)map);
    }

    public static Multimap<String, String> parse(String query, Multimap<String, String> map) {
        assert (map != null);
        int i = 0;
        int j = query.indexOf("&");
        while (j >= 0) {
            if (j > 0) {
                MultidictUtil.parseParam(query.substring(i, j), map);
            }
            i = j + 1;
            j = query.indexOf("&", i);
        }
        MultidictUtil.parseParam(query.substring(i), map);
        return map;
    }

    public static Multimap<String, String> parseParam(String str, Multimap<String, String> map) {
        if (LessStrings.isEmpty(str)) {
            return map;
        }
        int sep = str.indexOf(61);
        if (sep < 0) {
            map.put((Object)MultidictUtil.urlDecode(str), null);
        } else if (sep != 0) {
            if (sep < str.length() - 1) {
                map.put((Object)MultidictUtil.urlDecode(str.substring(0, sep)), (Object)MultidictUtil.urlDecode(str.substring(sep + 1)));
            } else {
                map.put((Object)MultidictUtil.urlDecode(str.substring(0, sep)), (Object)"");
            }
        }
        return map;
    }

    public static String toString(Multimap<String, String> map) {
        StringBuilder sb = new StringBuilder();
        Iterator i = map.entries().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            if (entry.getValue() == null) {
                sb.append(MultidictUtil.urlEncode((String)entry.getKey()));
            } else {
                sb.append(MultidictUtil.urlEncode((String)entry.getKey())).append("=").append(MultidictUtil.urlEncode((String)entry.getValue()));
            }
            if (!i.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    public static Dict asDict(Multidict multidict) {
        Dict dict = new Dict();
        for (String key : multidict.keySet()) {
            dict.put(key, multidict.get(key));
        }
        return dict;
    }

    private static String urlEncode(String string) {
        try {
            return string == null ? string : URLEncoder.encode(string, "UTF-8");
        }
        catch (Exception e) {
            return string;
        }
    }

    private static String urlDecode(String string) {
        try {
            return string == null ? string : URLDecoder.decode(string, "UTF-8");
        }
        catch (Exception e) {
            return string;
        }
    }
}

