/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.util;

import com.addthis.basis.util.FileLogger;
import com.addthis.basis.util.LessBytes;
import com.addthis.basis.util.LessFiles;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingLog
extends OutputStream
implements FileLogger {
    protected static final Logger log = LoggerFactory.getLogger(RollingLog.class);
    private final DateTimeFormatter format = DateTimeFormat.forPattern((String)"yyyyMMdd-HHmmss");
    private volatile boolean loggingEnabled = true;
    private File dir;
    private String prefix = "";
    private String suffix = "";
    private boolean compress;
    private long maxSize;
    private long maxAge;
    private long open;
    private File file;
    private File fileRename;
    private File cFile;
    private OutputStream out;

    public RollingLog(File dir, String prefix, boolean compress, long maxSize, long maxAge) {
        this(dir, prefix, "", compress, maxSize, maxAge);
    }

    public RollingLog(File dir, String pre, String suf, boolean compress, long maxSize, long maxAge) {
        dir.mkdirs();
        this.dir = LessFiles.initDirectory(dir);
        this.prefix = pre != null ? pre : "";
        String string = this.suffix = suf != null ? suf : "";
        if (this.prefix != "" && !this.prefix.endsWith("-")) {
            this.prefix = this.prefix + "-";
        }
        if (this.suffix != "" && !this.suffix.startsWith(".")) {
            this.suffix = "." + this.suffix;
        }
        this.compress = compress;
        this.maxSize = maxSize;
        this.maxAge = maxAge;
    }

    private void openNext() throws IOException {
        this.close();
        this.open = System.currentTimeMillis();
        String fname = this.prefix + this.format.print(this.open) + this.suffix;
        this.file = new File(this.dir, fname + ".tmp");
        this.out = new FileOutputStream(this.file);
        this.fileRename = new File(this.dir, fname);
        if (this.compress) {
            this.cFile = new File(this.dir, fname + ".gz");
        }
    }

    private void checkNext() throws IOException {
        if (this.out == null || this.maxAge > 0L && System.currentTimeMillis() - this.open > this.maxAge || this.maxSize > 0L && this.file.length() > this.maxSize) {
            this.openNext();
        }
    }

    @Override
    public synchronized void writeLine(String line) {
        if (this.loggingEnabled) {
            try {
                this.write(LessBytes.toBytes(line));
                this.write(10);
            }
            catch (IOException e) {
                log.debug("error writing to log file", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.checkNext();
        this.out.write(b);
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.checkNext();
        this.out.write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.checkNext();
        this.out.write(b, off, len);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.out != null) {
            this.out.flush();
            this.out.close();
            if (!this.file.renameTo(this.fileRename)) {
                log.info("file rename failed :: " + this.file + " --> " + this.fileRename);
            } else if (this.compress) {
                final File from = this.fileRename;
                final File to = this.cFile;
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        RollingLog.this.compressFile(from, to);
                    }
                });
                t.setDaemon(true);
                t.start();
            }
            this.out = null;
        }
    }

    @Override
    public boolean isLogging() {
        return this.loggingEnabled;
    }

    @Override
    public void startLogging() {
        this.loggingEnabled = true;
    }

    @Override
    public void stopLogging() {
        this.loggingEnabled = false;
    }

    private void compressFile(File current, File compressed) {
        try {
            int read;
            GZIPOutputStream cStream = new GZIPOutputStream(new FileOutputStream(compressed));
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(current));
            byte[] buffer = new byte[4096];
            while ((read = in.read(buffer)) != -1) {
                cStream.write(buffer, 0, read);
            }
            in.close();
            cStream.finish();
            cStream.close();
            if (!current.delete()) {
                log.info("file delete failed :: " + current);
            }
        }
        catch (IOException ioe) {
            log.debug("error compressing file", (Throwable)ioe);
            compressed.delete();
        }
    }
}

