/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.util;

import com.addthis.basis.util.LessBytes;
import java.io.IOException;
import java.io.InputStream;

public class SimpleExec {
    private Process process;
    private byte[] stdout;
    private byte[] stderr;
    private int exit;

    public SimpleExec(String cmd) throws IOException {
        this.process = Runtime.getRuntime().exec(cmd);
    }

    public SimpleExec(String[] cmd) throws IOException {
        this.process = Runtime.getRuntime().exec(cmd);
    }

    public SimpleExec join() throws InterruptedException, IOException {
        InputStream stdoutIn = this.process.getInputStream();
        InputStream stderrIn = this.process.getErrorStream();
        this.stdout = LessBytes.readFully(stdoutIn);
        this.stderr = LessBytes.readFully(stderrIn);
        this.exit = this.process.waitFor();
        return this;
    }

    public byte[] stdout() {
        return this.stdout;
    }

    public String stdoutString() {
        return LessBytes.toString(this.stdout);
    }

    public byte[] stderr() {
        return this.stderr;
    }

    public String stderrString() {
        return LessBytes.toString(this.stderr);
    }

    public int exitCode() {
        return this.exit;
    }
}

