/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.util;

import com.addthis.basis.util.TokenReplacerOverflowException;

public abstract class TokenReplacer {
    private final Region[] regions;

    public TokenReplacer(String begin, String end) {
        this(new Region(begin, end));
    }

    public TokenReplacer(Region region) {
        this(new Region[]{region});
    }

    public TokenReplacer(Region[] regions) {
        this.regions = regions;
    }

    public abstract String replace(Region var1, String var2);

    public abstract long getMaxDepth();

    public String process(String raw) throws TokenReplacerOverflowException {
        long depth;
        if (raw == null) {
            return null;
        }
        String input = raw;
        long maxDepth = this.getMaxDepth();
        boolean modified = true;
        for (depth = 0L; depth < maxDepth && modified; ++depth) {
            modified = false;
            for (Region region : this.regions) {
                int end;
                int next = raw.indexOf(region.start);
                if (next < 0 || (end = raw.indexOf(region.end, next + region.end.length())) <= 0) continue;
                String replace = this.replace(region, raw.substring(next + region.start.length(), end));
                if (replace == null) {
                    replace = "";
                }
                raw = raw.replace(raw.substring(next, end + region.end.length()), replace);
                modified = true;
            }
        }
        if (depth == maxDepth) {
            throw new TokenReplacerOverflowException(input, maxDepth);
        }
        return raw;
    }

    public static class Region {
        private final String start;
        private final String end;

        public Region(String start, String end) {
            this.start = start;
            this.end = end;
        }
    }
}

