/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.binary;

import com.addthis.basis.util.LessBytes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;

final class BufferOut {
    ByteArrayOutputStream out;
    Stack<ByteArrayOutputStream> stack = new Stack();

    BufferOut() {
        this.push();
    }

    public OutputStream out() {
        return this.out;
    }

    public void push() {
        this.stack.push(new ByteArrayOutputStream());
        this.out = this.stack.peek();
    }

    public void pop() throws IOException {
        ByteArrayOutputStream last = this.stack.pop();
        this.out = this.stack.peek();
        LessBytes.writeLength((long)last.size(), (OutputStream)this.out());
        last.writeTo(this.out());
    }

    public String toString() {
        return "BufferOut:" + (this.out != null ? this.out.size() : -1);
    }
}

