/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.config;

import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

abstract class ConfigNodeCursor
extends JsonStreamContext {
    protected final ConfigNodeCursor _parent;
    @Nullable
    protected String _currentName;

    public ConfigNodeCursor(int contextType, ConfigNodeCursor p) {
        this._type = contextType;
        this._index = -1;
        this._parent = p;
    }

    public final ConfigNodeCursor getParent() {
        return this._parent;
    }

    @Nullable
    public final String getCurrentName() {
        return this._currentName;
    }

    public void overrideCurrentName(String name) {
        this._currentName = name;
    }

    public abstract JsonToken nextToken();

    public abstract JsonToken nextValue();

    public abstract JsonToken endToken();

    public abstract ConfigValue currentNode();

    public abstract boolean currentHasChildren();

    public final ConfigNodeCursor iterateChildren() {
        ConfigValue n = this.currentNode();
        if (n == null) {
            throw new IllegalStateException("No current node");
        }
        if (n.valueType() == ConfigValueType.LIST) {
            return new Array((ConfigList)n, this);
        }
        if (n.valueType() == ConfigValueType.OBJECT) {
            return new Object((ConfigObject)n, this);
        }
        throw new IllegalStateException("Current node of type " + n.getClass().getName());
    }

    static JsonToken forConfigValue(ConfigValue configValue) {
        ConfigValueType valueType = configValue.valueType();
        switch (valueType) {
            case NUMBER: {
                if (configValue.unwrapped() instanceof Double) {
                    return JsonToken.VALUE_NUMBER_FLOAT;
                }
                return JsonToken.VALUE_NUMBER_INT;
            }
            case BOOLEAN: {
                if (configValue.unwrapped().equals(Boolean.TRUE)) {
                    return JsonToken.VALUE_TRUE;
                }
                return JsonToken.VALUE_FALSE;
            }
            case NULL: {
                return JsonToken.VALUE_NULL;
            }
            case STRING: {
                return JsonToken.VALUE_STRING;
            }
            case OBJECT: {
                return JsonToken.START_OBJECT;
            }
            case LIST: {
                return JsonToken.START_ARRAY;
            }
        }
        throw new IllegalArgumentException(valueType.name() + " is not a supported ConfigValueType");
    }

    protected static final class Object
    extends ConfigNodeCursor {
        private final Iterator<Map.Entry<String, ConfigValue>> _contents;
        @Nullable
        private Map.Entry<String, ConfigValue> _current;
        private boolean _needEntry;

        public Object(ConfigObject n, ConfigNodeCursor p) {
            super(2, p);
            this._contents = n.entrySet().iterator();
            this._needEntry = true;
        }

        @Override
        @Nullable
        public JsonToken nextToken() {
            if (this._needEntry) {
                if (!this._contents.hasNext()) {
                    this._currentName = null;
                    this._current = null;
                    return null;
                }
                this._needEntry = false;
                this._current = this._contents.next();
                this._currentName = this._current == null ? null : this._current.getKey();
                return JsonToken.FIELD_NAME;
            }
            this._needEntry = true;
            return Object.forConfigValue(this._current.getValue());
        }

        @Override
        public JsonToken nextValue() {
            JsonToken t = this.nextToken();
            if (t == JsonToken.FIELD_NAME) {
                t = this.nextToken();
            }
            return t;
        }

        @Override
        public JsonToken endToken() {
            return JsonToken.END_OBJECT;
        }

        @Override
        public ConfigValue currentNode() {
            if (this._current == null) {
                return null;
            }
            return this._current.getValue();
        }

        @Override
        public boolean currentHasChildren() {
            ConfigValue currentValue = this.currentNode();
            if (currentValue.valueType() == ConfigValueType.LIST) {
                return !((ConfigList)currentValue).isEmpty();
            }
            return !((ConfigObject)currentValue).isEmpty();
        }
    }

    protected static final class Array
    extends ConfigNodeCursor {
        private final Iterator<ConfigValue> _contents;
        @Nullable
        private ConfigValue _currentNode;

        public Array(ConfigList n, ConfigNodeCursor p) {
            super(1, p);
            this._contents = n.iterator();
        }

        @Override
        @Nullable
        public JsonToken nextToken() {
            if (!this._contents.hasNext()) {
                this._currentNode = null;
                return null;
            }
            this._currentNode = this._contents.next();
            return Array.forConfigValue(this._currentNode);
        }

        @Override
        public JsonToken nextValue() {
            return this.nextToken();
        }

        @Override
        public JsonToken endToken() {
            return JsonToken.END_ARRAY;
        }

        @Override
        public ConfigValue currentNode() {
            return this._currentNode;
        }

        @Override
        public boolean currentHasChildren() {
            ConfigValue currentValue = this.currentNode();
            if (currentValue.valueType() == ConfigValueType.LIST) {
                return !((ConfigList)currentValue).isEmpty();
            }
            return !((ConfigObject)currentValue).isEmpty();
        }
    }

    protected static final class RootValue
    extends ConfigNodeCursor {
        @Nullable
        private ConfigValue _node;
        private boolean _done = false;

        public RootValue(ConfigValue n, ConfigNodeCursor p) {
            super(0, p);
            this._node = n;
        }

        @Override
        public void overrideCurrentName(String name) {
        }

        @Override
        @Nullable
        public JsonToken nextToken() {
            if (!this._done) {
                this._done = true;
                return RootValue.forConfigValue(this._node);
            }
            this._node = null;
            return null;
        }

        @Override
        @Nullable
        public JsonToken nextValue() {
            return this.nextToken();
        }

        @Override
        @Nullable
        public JsonToken endToken() {
            return null;
        }

        @Override
        public ConfigValue currentNode() {
            return this._node;
        }

        @Override
        public boolean currentHasChildren() {
            return false;
        }
    }
}

