/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.config;

import com.addthis.codec.config.ConfigNodeCursor;
import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ConfigTraversingParser
extends ParserMinimalBase {
    protected ObjectCodec _objectCodec;
    protected ConfigNodeCursor _nodeCursor;
    protected JsonToken _nextToken;
    protected boolean _startContainer;
    protected boolean _closed;
    protected ConfigValue currentConfig;

    public ConfigTraversingParser(ConfigValue n) {
        this(n, null);
    }

    public ConfigTraversingParser(ConfigValue n, ObjectCodec codec) {
        super(0);
        this._objectCodec = codec;
        this.currentConfig = n;
        if (n.valueType() == ConfigValueType.LIST) {
            this._nextToken = JsonToken.START_ARRAY;
            this._nodeCursor = new ConfigNodeCursor.Array((ConfigList)n, null);
        } else if (n.valueType() == ConfigValueType.OBJECT) {
            this._nextToken = JsonToken.START_OBJECT;
            this._nodeCursor = new ConfigNodeCursor.Object((ConfigObject)n, null);
        } else {
            this._nodeCursor = new ConfigNodeCursor.RootValue(n, null);
        }
    }

    public void setCodec(ObjectCodec c) {
        this._objectCodec = c;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public void close() {
        if (!this._closed) {
            this._closed = true;
            this._nodeCursor = null;
            this._currToken = null;
        }
    }

    public ConfigValue currentConfig() {
        if (this._nextToken != null) {
            return null;
        }
        return this.currentConfig;
    }

    public JsonToken nextToken() throws IOException, JsonParseException {
        if (this._nextToken != null) {
            this._currToken = this._nextToken;
            this._nextToken = null;
            return this._currToken;
        }
        if (this._startContainer) {
            this._startContainer = false;
            if (!this._nodeCursor.currentHasChildren()) {
                this._currToken = this._currToken == JsonToken.START_OBJECT ? JsonToken.END_OBJECT : JsonToken.END_ARRAY;
                return this._currToken;
            }
            this._nodeCursor = this._nodeCursor.iterateChildren();
            this._currToken = this._nodeCursor.nextToken();
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                this._startContainer = true;
            }
            this.currentConfig = this.currentNode();
            return this._currToken;
        }
        if (this._nodeCursor == null) {
            this._closed = true;
            this.currentConfig = null;
            return null;
        }
        this._currToken = this._nodeCursor.nextToken();
        if (this._currToken != null) {
            this.currentConfig = this.currentNode();
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                this._startContainer = true;
            }
            return this._currToken;
        }
        this._currToken = this._nodeCursor.endToken();
        this._nodeCursor = this._nodeCursor.getParent();
        this.currentConfig = this.currentNode();
        return this._currToken;
    }

    public JsonParser skipChildren() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.START_OBJECT) {
            this._startContainer = false;
            this._currToken = JsonToken.END_OBJECT;
        } else if (this._currToken == JsonToken.START_ARRAY) {
            this._startContainer = false;
            this._currToken = JsonToken.END_ARRAY;
        }
        return this;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public String getCurrentName() {
        if (this._nodeCursor == null) {
            return null;
        }
        return this._nodeCursor.getCurrentName();
    }

    public void overrideCurrentName(String name) {
        if (this._nodeCursor != null) {
            this._nodeCursor.overrideCurrentName(name);
        }
    }

    public JsonStreamContext getParsingContext() {
        return this._nodeCursor;
    }

    public JsonLocation getTokenLocation() {
        ConfigValue current = this.currentConfig();
        if (current == null) {
            return JsonLocation.NA;
        }
        ConfigOrigin nodeOrigin = current.origin();
        return new JsonLocation((Object)current, -1L, nodeOrigin.lineNumber(), -1);
    }

    public JsonLocation getCurrentLocation() {
        return this.getTokenLocation();
    }

    public String getText() {
        if (this._closed) {
            return null;
        }
        switch (this._currToken) {
            case FIELD_NAME: {
                return this._nodeCursor.getCurrentName();
            }
            case VALUE_STRING: {
                return (String)this.currentNode().unwrapped();
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return String.valueOf(this.currentNode().unwrapped());
            }
        }
        if (this._currToken == null) {
            return null;
        }
        return this._currToken.asString();
    }

    public char[] getTextCharacters() throws IOException, JsonParseException {
        return this.getText().toCharArray();
    }

    public int getTextLength() throws IOException, JsonParseException {
        return this.getText().length();
    }

    public int getTextOffset() throws IOException, JsonParseException {
        return 0;
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        JsonNode n = this.currentNumericNode();
        return n == null ? null : n.numberType();
    }

    public BigInteger getBigIntegerValue() throws IOException, JsonParseException {
        return this.currentNumericNode().bigIntegerValue();
    }

    public BigDecimal getDecimalValue() throws IOException, JsonParseException {
        return this.currentNumericNode().decimalValue();
    }

    public double getDoubleValue() throws IOException, JsonParseException {
        return this.currentNumericNode().doubleValue();
    }

    public float getFloatValue() throws IOException, JsonParseException {
        return (float)this.currentNumericNode().doubleValue();
    }

    public long getLongValue() throws IOException, JsonParseException {
        return this.currentNumericNode().longValue();
    }

    public int getIntValue() throws IOException, JsonParseException {
        JsonNode numericNode = this.currentNumericNode();
        if (numericNode.canConvertToInt()) {
            return this.currentNumericNode().intValue();
        }
        throw this._constructError("Numeric value (" + this.getText() + ") out of range of Java short");
    }

    public Number getNumberValue() throws IOException, JsonParseException {
        return this.currentNumericNode().numberValue();
    }

    public Object getEmbeddedObject() {
        return null;
    }

    public byte[] getBinaryValue(Base64Variant b64variant) throws IOException, JsonParseException {
        return null;
    }

    public int readBinaryValue(Base64Variant b64variant, OutputStream out) throws IOException, JsonParseException {
        return 0;
    }

    protected ConfigValue currentNode() {
        if (this._closed || this._nodeCursor == null) {
            return null;
        }
        return this._nodeCursor.currentNode();
    }

    protected JsonNode currentNumericNode() throws JsonParseException {
        ConfigValue configValue = this.currentNode();
        if (configValue == null || configValue.valueType() != ConfigValueType.NUMBER) {
            JsonToken t = configValue == null ? null : ConfigNodeCursor.forConfigValue(configValue);
            throw this._constructError("Current token (" + t + ") not numeric, can not use numeric value accessors");
        }
        Number value = (Number)configValue.unwrapped();
        if (value instanceof Double) {
            return JsonNodeFactory.instance.numberNode((Double)value);
        }
        if (value instanceof Long) {
            return JsonNodeFactory.instance.numberNode((Long)value);
        }
        if (value instanceof Integer) {
            return JsonNodeFactory.instance.numberNode((Integer)value);
        }
        throw this._constructError(value.getClass() + " is not a supported numeric config type");
    }

    protected void _handleEOF() throws JsonParseException {
        this._throwInternal();
    }
}

