/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.config;

import com.addthis.codec.jackson.Jackson;
import com.addthis.codec.plugins.PluginMap;
import com.addthis.codec.plugins.PluginRegistry;
import com.addthis.codec.reflection.CodableClassInfo;
import com.addthis.codec.reflection.CodableFieldInfo;
import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.config.ConfigValueType;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Syntax;

@Beta
public final class Configs {
    private Configs() {
    }

    public static <T> T newDefault(@Nonnull Class<T> type) throws IOException {
        return Jackson.defaultCodec().newDefault(type);
    }

    public static <T> T newDefault(@Nonnull String category) throws IOException {
        return Jackson.defaultCodec().newDefault(category);
    }

    public static <T> T decodeObject(@Nonnull Class<T> type, @Nonnull Config config) throws IOException {
        return Jackson.defaultCodec().decodeObject(type, config);
    }

    public static <T> T decodeObject(@Nonnull String category, @Nonnull Config config) throws IOException {
        return Jackson.defaultCodec().decodeObject(category, config);
    }

    public static <T> T decodeObject(@Nonnull Class<T> type, @Syntax(value="HOCON") @Nonnull String configText) throws IOException {
        return Jackson.defaultCodec().decodeObject(type, configText);
    }

    public static <T> T decodeObject(@Nonnull String category, @Syntax(value="HOCON") @Nonnull String configText) throws IOException {
        return Jackson.defaultCodec().decodeObject(category, configText);
    }

    public static <T> T decodeObject(@Syntax(value="HOCON") String configText) throws IOException {
        return Jackson.defaultCodec().decodeObject(configText);
    }

    public static <T> T decodeObject(Config config) throws IOException {
        return Jackson.defaultCodec().decodeObject(config);
    }

    public static ConfigValue expandSugar(Config config, PluginRegistry pluginRegistry) {
        if (config.root().size() != 1) {
            throw new ConfigException.Parse(config.root().origin(), "config root must have exactly one key");
        }
        String category = (String)config.root().keySet().iterator().next();
        PluginMap pluginMap = pluginRegistry.asMap().get(category);
        if (pluginMap == null) {
            throw new ConfigException.BadValue(config.root().get((Object)category).origin(), category, "top level key must be a valid category");
        }
        Class baseClass = (Class)Objects.firstNonNull(pluginMap.baseClass(), Object.class);
        return Configs.expandSugar(baseClass, config.root().get((Object)category), pluginRegistry);
    }

    public static ConfigValue expandSugar(Class<?> type, ConfigValue config, PluginRegistry pluginRegistry) {
        if (type != null && type.isAssignableFrom(ConfigValue.class)) {
            return ConfigValueFactory.fromAnyRef((Object)config.unwrapped(), (String)("unchanged for raw ConfigValue field " + config.origin().description()));
        }
        CodableClassInfo typeInfo = new CodableClassInfo(type, pluginRegistry.config(), pluginRegistry);
        PluginMap pluginMap = typeInfo.getPluginMap();
        ConfigValue valueOrResolvedRoot = Configs.resolveType(type, config, pluginMap);
        if (valueOrResolvedRoot.valueType() != ConfigValueType.OBJECT) {
            return valueOrResolvedRoot;
        }
        ConfigObject root = (ConfigObject)valueOrResolvedRoot;
        String classField = pluginMap.classField();
        if (root.get((Object)classField) != null) {
            try {
                type = pluginMap.getClass((String)root.get((Object)classField).unwrapped());
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        return Configs.expandSugarSkipResolve(type, root, pluginRegistry);
    }

    private static ConfigObject expandSugarSkipResolve(Class<?> type, ConfigObject root, PluginRegistry pluginRegistry) {
        CodableClassInfo resolvedTypeInfo = new CodableClassInfo(type, pluginRegistry.config(), pluginRegistry);
        ConfigObject fieldDefaults = resolvedTypeInfo.getFieldDefaults().root();
        for (CodableFieldInfo fieldInfo : resolvedTypeInfo.values()) {
            boolean nested;
            Class<?> elementType;
            String fieldName = fieldInfo.getName();
            ConfigValue fieldValue = root.get((Object)fieldName);
            if (fieldValue == null && fieldDefaults.get((Object)fieldName) != null) {
                ConfigValue fieldDefault = fieldDefaults.get((Object)fieldName);
                fieldValue = ConfigValueFactory.fromAnyRef((Object)fieldDefault.unwrapped(), (String)("global default : " + fieldDefault.origin().description()));
                root = root.withValue(fieldName, fieldValue);
            }
            if (fieldValue == null) continue;
            if ((fieldInfo.isArray() || fieldInfo.isCollection()) && fieldValue.valueType() != ConfigValueType.LIST) {
                fieldValue = ConfigValueFactory.fromIterable(Collections.singletonList(fieldValue.unwrapped()), (String)("auto collection of " + fieldValue.origin().description()));
                root = root.withValue(fieldName, fieldValue);
            }
            if (!Configs.isCodableType(fieldInfo)) continue;
            if (fieldInfo.isArray() || fieldInfo.isCollection()) {
                if (fieldValue.valueType() != ConfigValueType.LIST) {
                    throw new ConfigException.WrongType(fieldValue.origin(), fieldName, ConfigValueType.LIST.name(), fieldValue.valueType().name());
                }
                elementType = Configs.elementType(fieldInfo);
                nested = fieldInfo.isCollectionArray();
                fieldValue = Configs.expandSugarArray(fieldValue, elementType, pluginRegistry, nested);
            } else if (fieldInfo.isMap()) {
                if (fieldValue.valueType() != ConfigValueType.OBJECT) {
                    throw new ConfigException.WrongType(fieldValue.origin(), fieldName, ConfigValueType.OBJECT.name(), fieldValue.valueType().name());
                }
                elementType = Configs.elementType(fieldInfo);
                nested = fieldInfo.isMapValueArray();
                ConfigObject fieldMap = (ConfigObject)fieldValue;
                HashMap<String, Object> newMap = new HashMap<String, Object>(fieldMap.size());
                for (Map.Entry mapEntry : fieldMap.entrySet()) {
                    ConfigValue mapValue = (ConfigValue)mapEntry.getValue();
                    String mapKey = (String)mapEntry.getKey();
                    Object resolvedMapObject = nested ? Configs.expandSugarArray(mapValue, elementType, pluginRegistry, false) : Configs.expandSugar(elementType, mapValue, pluginRegistry);
                    newMap.put(mapKey, resolvedMapObject.unwrapped());
                }
                fieldValue = ConfigValueFactory.fromMap(newMap, (String)fieldMap.origin().description());
            } else {
                fieldValue = Configs.expandSugar(fieldInfo.getTypeOrComponentType(), fieldValue, pluginRegistry);
            }
            root = root.withValue(fieldName, fieldValue);
        }
        return root;
    }

    private static ConfigList expandSugarArray(ConfigValue fieldValue, Class<?> elementType, PluginRegistry pluginRegistry, boolean nested) {
        ConfigList fieldList = (ConfigList)fieldValue;
        ArrayList<Object> newList = new ArrayList<Object>(fieldList.size());
        for (ConfigValue listEntry : fieldList) {
            Object listObject = nested ? Configs.expandSugarArray(listEntry, elementType, pluginRegistry, false) : Configs.expandSugar(elementType, listEntry, pluginRegistry);
            newList.add(listObject.unwrapped());
        }
        return ConfigValueFactory.fromIterable(newList, (String)fieldList.origin().description());
    }

    private static Class<?> elementType(CodableFieldInfo fieldInfo) {
        Class<?> elementType = fieldInfo.getTypeOrComponentType();
        if (fieldInfo.isMap()) {
            elementType = fieldInfo.getMapValueClass();
        } else if (fieldInfo.isCollection()) {
            elementType = fieldInfo.getCollectionClass();
        }
        return elementType;
    }

    private static boolean isCodableType(CodableFieldInfo fieldInfo) {
        Class<String> expectedType = Configs.elementType(fieldInfo);
        if (expectedType.isAssignableFrom(String.class)) {
            return false;
        }
        if (expectedType == Boolean.TYPE || expectedType == Boolean.class) {
            return false;
        }
        if (expectedType == AtomicBoolean.class) {
            return false;
        }
        if (Number.class.isAssignableFrom(expectedType) || expectedType.isPrimitive()) {
            return false;
        }
        return !expectedType.isEnum();
    }

    private static ConfigValue resolveType(Class<?> type, ConfigValue configValue, PluginMap pluginMap) {
        String classField = pluginMap.classField();
        if (configValue.valueType() != ConfigValueType.OBJECT) {
            Class<?> arrayType;
            if ((type == null || Modifier.isAbstract(type.getModifiers()) || Modifier.isInterface(type.getModifiers())) && configValue.valueType() == ConfigValueType.LIST && (arrayType = pluginMap.arraySugar()) != null) {
                ConfigObject aliasDefaults = pluginMap.aliasDefaults("_array");
                String arrayFieldName = aliasDefaults.toConfig().getString("_primary");
                String arraySugarName = pluginMap.getLastAlias("_array");
                return ConfigFactory.empty().root().withValue(classField, ConfigValueFactory.fromAnyRef((Object)arraySugarName, (String)(pluginMap.category() + " array sugar : " + pluginMap.config().root().get((Object)"_array").origin().description()))).withValue(arrayFieldName, configValue).withFallback((ConfigMergeable)aliasDefaults);
            }
            return configValue;
        }
        ConfigObject root = (ConfigObject)configValue;
        ConfigValue classValue = root.get((Object)classField);
        if (classValue != null && classValue.valueType() == ConfigValueType.STRING) {
            String classValueString = (String)classValue.unwrapped();
            ConfigObject aliasDefaults = pluginMap.aliasDefaults(classValueString);
            return root.withFallback((ConfigMergeable)aliasDefaults);
        }
        if (type == null || Modifier.isAbstract(type.getModifiers()) || Modifier.isInterface(type.getModifiers())) {
            if (root.size() == 1) {
                String onlyKey = (String)root.keySet().iterator().next();
                try {
                    pluginMap.getClass(onlyKey);
                    ConfigValue onlyKeyValue = (ConfigValue)root.values().iterator().next();
                    ConfigObject aliasDefaults = pluginMap.aliasDefaults(onlyKey);
                    if (onlyKeyValue.valueType() != ConfigValueType.OBJECT) {
                        if (aliasDefaults.get((Object)"_primary") != null) {
                            onlyKeyValue = onlyKeyValue.atPath((String)aliasDefaults.get((Object)"_primary").unwrapped()).root();
                        } else {
                            throw new ConfigException.WrongType(onlyKeyValue.origin(), onlyKey, "OBJECT", onlyKeyValue.valueType().toString());
                        }
                    }
                    ConfigObject fieldValues = (ConfigObject)onlyKeyValue;
                    return fieldValues.withValue(classField, ConfigValueFactory.fromAnyRef((Object)onlyKey, (String)("single key to type from " + root.origin().description()))).withFallback((ConfigMergeable)aliasDefaults);
                }
                catch (ClassNotFoundException ignored) {
                    // empty catch block
                }
            }
            String matched = null;
            for (String alias : pluginMap.inlinedAliases()) {
                if (root.get((Object)alias) == null) continue;
                if (matched != null) {
                    String message = String.format("no type specified, more than one key, and both %s and %s match for inlined types.", matched, alias);
                    throw new ConfigException.Parse(root.origin(), message);
                }
                matched = alias;
            }
            if (matched != null) {
                ConfigObject aliasDefaults = pluginMap.aliasDefaults(matched);
                ConfigValue inlinedValue = root.get(matched);
                String primaryField = (String)aliasDefaults.get((Object)"_primary").unwrapped();
                ConfigObject fieldValues = root.toConfig().withValue(primaryField, inlinedValue).root().withoutKey(matched).withFallback((ConfigMergeable)aliasDefaults);
                return fieldValues.withValue(classField, ConfigValueFactory.fromAnyRef((Object)matched, (String)("inlined key to type from " + root.origin().description())));
            }
            ConfigValue defaultObject = pluginMap.config().root().get((Object)"_default");
            if (defaultObject != null) {
                String defaultName = pluginMap.getLastAlias("_default");
                ConfigObject aliasDefaults = pluginMap.aliasDefaults("_default");
                return root.withValue(classField, ConfigValueFactory.fromAnyRef((Object)defaultName, (String)(pluginMap.category() + " default type : " + defaultObject.origin().description()))).withFallback((ConfigMergeable)aliasDefaults);
            }
        }
        return root;
    }
}

