/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.jackson;

import com.addthis.codec.annotations.Bytes;
import com.addthis.codec.annotations.Time;
import com.addthis.codec.codables.SuperCodable;
import com.addthis.codec.jackson.Jackson;
import com.addthis.codec.jackson.MissingPropertyException;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.NameTransformer;
import io.dropwizard.util.Duration;
import io.dropwizard.util.Size;
import java.io.IOException;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecBeanDeserializer
extends DelegatingDeserializer {
    private static final Logger log = LoggerFactory.getLogger(CodecBeanDeserializer.class);
    private static final Pattern NUMBER_UNIT = Pattern.compile("(\\d+)\\s*([^\\s\\d]+)");
    private final ObjectNode fieldDefaults;

    protected CodecBeanDeserializer(BeanDeserializerBase src, ObjectNode fieldDefaults) {
        super((JsonDeserializer)src);
        this.fieldDefaults = fieldDefaults;
    }

    public BeanDeserializerBase getDelegatee() {
        return (BeanDeserializerBase)this._delegatee;
    }

    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
        return new CodecBeanDeserializer((BeanDeserializerBase)newDelegatee, this.fieldDefaults);
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonLocation currentLocation = jp.getTokenLocation();
        JsonToken t = jp.getCurrentToken();
        try {
            ObjectNode objectNode;
            if (t == JsonToken.START_OBJECT) {
                objectNode = (ObjectNode)jp.readValueAsTree();
                this.handleDefaultsAndRequiredAndNull(ctxt, objectNode);
                jp = jp.getCodec().treeAsTokens((TreeNode)objectNode);
                jp.nextToken();
            } else if (t == JsonToken.END_OBJECT) {
                jp.nextToken();
                objectNode = ctxt.getNodeFactory().objectNode();
                this.handleDefaultsAndRequiredAndNull(ctxt, objectNode);
                jp = jp.getCodec().treeAsTokens((TreeNode)objectNode);
                jp.nextToken();
            }
            Object value = this.getDelegatee().deserialize(jp, ctxt);
            if (value instanceof SuperCodable) {
                ((SuperCodable)value).postDecode();
            }
            return value;
        }
        catch (JsonMappingException ex) {
            throw Jackson.maybeImproveLocation(currentLocation, ex);
        }
    }

    private void handleDefaultsAndRequiredAndNull(DeserializationContext ctxt, ObjectNode fieldValues) throws JsonMappingException {
        Iterator propertyIterator = this.getDelegatee().properties();
        while (propertyIterator.hasNext()) {
            SettableBeanProperty prop = (SettableBeanProperty)propertyIterator.next();
            String propertyName = prop.getName();
            JsonNode fieldValue = fieldValues.path(propertyName);
            if (fieldValue.isMissingNode() || fieldValue.isNull()) {
                if (this.fieldDefaults.hasNonNull(propertyName)) {
                    fieldValue = this.fieldDefaults.get(propertyName).deepCopy();
                    fieldValues.set(propertyName, fieldValue);
                } else {
                    if (prop.isRequired()) {
                        throw MissingPropertyException.from(ctxt.getParser(), prop.getType().getRawClass(), propertyName, this.getKnownPropertyNames());
                    }
                    if (fieldValue.isNull() && (prop.getType().isPrimitive() || prop.getValueDeserializer().getNullValue() == null)) {
                        fieldValues.remove(propertyName);
                    }
                }
            }
            if (!fieldValue.isTextual()) continue;
            try {
                long asLong;
                Time time = (Time)prop.getAnnotation(Time.class);
                if (time != null && NUMBER_UNIT.matcher(fieldValue.textValue()).matches()) {
                    Duration dropWizardDuration = Duration.parse((String)fieldValue.asText());
                    asLong = time.value().convert(dropWizardDuration.getQuantity(), dropWizardDuration.getUnit());
                    fieldValues.put(propertyName, asLong);
                    continue;
                }
                if (prop.getAnnotation(Bytes.class) == null || !NUMBER_UNIT.matcher(fieldValue.textValue()).matches()) continue;
                Size dropWizardSize = Size.parse((String)fieldValue.asText());
                asLong = dropWizardSize.toBytes();
                fieldValues.put(propertyName, asLong);
            }
            catch (Throwable cause) {
                throw JsonMappingException.wrapWithPath((Throwable)cause, (Object)prop.getType().getRawClass(), (String)propertyName);
            }
        }
    }

    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer unwrapper) {
        return this.replaceDelegatee(this.getDelegatee().unwrappingDeserializer(unwrapper));
    }
}

