/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.jackson;

import com.addthis.codec.jackson.CaseIgnoringEnumDeserializer;
import com.addthis.codec.jackson.CodecBeanDeserializer;
import com.addthis.codec.jackson.Jackson;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.std.EnumDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.EnumResolver;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecBeanDeserializerModifier
extends BeanDeserializerModifier {
    private static final Logger log = LoggerFactory.getLogger(CodecBeanDeserializerModifier.class);
    private final Config globalDefaults;
    private final boolean modifyEnum;

    public CodecBeanDeserializerModifier(Config globalDefaults) {
        this.globalDefaults = globalDefaults;
        this.modifyEnum = globalDefaults.getBoolean("addthis.codec.jackson.ignore.enum-case");
    }

    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        JsonDeserializer delegatee = deserializer.getDelegatee();
        if (delegatee != null) {
            JsonDeserializer<?> replacementDelegatee = this.modifyDeserializer(config, beanDesc, delegatee);
            return deserializer.replaceDelegatee(replacementDelegatee);
        }
        if (deserializer instanceof BeanDeserializerBase) {
            BeanDeserializerBase beanDeserializer = (BeanDeserializerBase)deserializer;
            ObjectNode fieldDefaults = config.getNodeFactory().objectNode();
            Iterator propertyIterator = beanDeserializer.properties();
            while (propertyIterator.hasNext()) {
                String propertyName;
                Config declarerDefaults;
                SettableBeanProperty prop = (SettableBeanProperty)propertyIterator.next();
                Class declaringClass = prop.getMember().getDeclaringClass();
                String canonicalClassName = declaringClass.getCanonicalName();
                if (canonicalClassName == null || !this.globalDefaults.hasPath(canonicalClassName) || !(declarerDefaults = this.globalDefaults.getConfig(canonicalClassName)).hasPath(propertyName = prop.getName())) continue;
                ConfigValue defaultValue = declarerDefaults.getValue(propertyName);
                JsonNode fieldDefault = Jackson.configConverter(defaultValue);
                fieldDefaults.set(propertyName, fieldDefault);
            }
            return new CodecBeanDeserializer(beanDeserializer, fieldDefaults);
        }
        return deserializer;
    }

    public JsonDeserializer<?> modifyEnumDeserializer(DeserializationConfig config, JavaType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        JsonDeserializer delegatee = deserializer.getDelegatee();
        if (delegatee != null) {
            JsonDeserializer<?> replacementDelegatee = this.modifyEnumDeserializer(config, type, beanDesc, delegatee);
            return deserializer.replaceDelegatee(replacementDelegatee);
        }
        if (this.modifyEnum && deserializer.getClass().equals(EnumDeserializer.class)) {
            EnumResolver enumResolver = EnumResolver.constructUnsafe((Class)type.getRawClass(), (AnnotationIntrospector)config.getAnnotationIntrospector());
            return new CaseIgnoringEnumDeserializer(enumResolver);
        }
        return deserializer;
    }
}

