/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.jackson;

import com.addthis.codec.jackson.CodecBeanDeserializerModifier;
import com.addthis.codec.jackson.CodecIntrospector;
import com.addthis.codec.jackson.UnderscorePropertyIgnorer;
import com.addthis.codec.jackson.WriteonlyPropertyIgnorer;
import com.addthis.codec.plugins.PluginRegistry;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.typesafe.config.Config;

public class CodecModule
extends Module {
    private final PluginRegistry pluginRegistry;
    private final Config globalConfig;

    public CodecModule(PluginRegistry pluginRegistry, Config globalConfig) {
        this.pluginRegistry = pluginRegistry;
        this.globalConfig = globalConfig;
    }

    public CodecModule(PluginRegistry pluginRegistry) {
        this.pluginRegistry = pluginRegistry;
        this.globalConfig = pluginRegistry.config();
    }

    public void setupModule(Module.SetupContext context) {
        context.appendAnnotationIntrospector((AnnotationIntrospector)new CodecIntrospector(this.pluginRegistry));
        if (this.globalConfig.getBoolean("addthis.codec.jackson.ignore.underscore")) {
            context.addDeserializationProblemHandler((DeserializationProblemHandler)new UnderscorePropertyIgnorer());
        }
        if (this.globalConfig.getBoolean("addthis.codec.jackson.ignore.write-only")) {
            context.addDeserializationProblemHandler((DeserializationProblemHandler)new WriteonlyPropertyIgnorer());
        }
        if (this.globalConfig.getBoolean("addthis.codec.jackson.modify-fields")) {
            context.addBeanDeserializerModifier((BeanDeserializerModifier)new CodecBeanDeserializerModifier(this.globalConfig));
        }
    }

    public String getModuleName() {
        return "addthis-codec";
    }

    public Version version() {
        return Version.unknownVersion();
    }
}

