/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.jackson;

import com.addthis.codec.plugins.PluginMap;
import com.addthis.codec.plugins.PluginRegistry;
import com.addthis.codec.plugins.Plugins;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import java.util.Collection;

public class CodecTypeIdResolver
extends TypeIdResolverBase {
    private final PluginMap pluginMap;
    private final BiMap<String, Class<?>> extraSubTypes;
    private final PluginRegistry pluginRegistry;

    public CodecTypeIdResolver(PluginMap pluginMap, JavaType baseType, TypeFactory typeFactory, Collection<NamedType> subtypes, PluginRegistry pluginRegistry) {
        super(baseType, typeFactory);
        this.pluginRegistry = pluginRegistry;
        if (!subtypes.isEmpty()) {
            HashBiMap mutableExtraSubTypes = HashBiMap.create((int)subtypes.size());
            for (NamedType namedType : subtypes) {
                if (!namedType.hasName()) continue;
                mutableExtraSubTypes.put((Object)namedType.getName(), (Object)namedType.getType());
            }
            this.extraSubTypes = Maps.unmodifiableBiMap((BiMap)mutableExtraSubTypes);
        } else {
            this.extraSubTypes = ImmutableBiMap.of();
        }
        this.pluginMap = pluginMap;
    }

    public boolean isValidTypeId(String typeId) {
        Class<?> cls = this.pluginMap.getClassIfConfigured(typeId);
        if (cls == null) {
            cls = (Class<?>)this.extraSubTypes.get((Object)typeId);
        }
        try {
            if (cls == null) {
                cls = this.pluginMap.getClass(typeId);
            }
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
        return this._baseType.getRawClass().isAssignableFrom(cls);
    }

    public JavaType typeFromId(DatabindContext context, String id) {
        return this._typeFromId(id, context.getTypeFactory());
    }

    public String idFromValue(Object value) {
        return this.pluginMap.getClassName(value.getClass());
    }

    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        String alt = (String)this.pluginMap.asBiMap().inverse().get(suggestedType);
        if (alt != null) {
            return alt;
        }
        if (this.extraSubTypes.containsValue(suggestedType)) {
            return (String)this.extraSubTypes.inverse().get(suggestedType);
        }
        return this.pluginMap.getClassName(suggestedType);
    }

    public JavaType typeFromId(String id) {
        return this._typeFromId(id, this._typeFactory);
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    private JavaType _typeFromId(String id, TypeFactory typeFactory) {
        if (id == null) {
            return null;
        }
        Class<?> cls = this.pluginMap.getClassIfConfigured(id);
        if (cls == null) {
            cls = (Class<?>)this.extraSubTypes.get((Object)id);
        }
        try {
            if (cls == null) {
                cls = this.pluginMap.getClass(id);
            }
            return typeFactory.constructSpecializedType(this._baseType, cls);
        }
        catch (Exception e) {
            String helpMessage = Plugins.classNameSuggestions(this.pluginRegistry, this.pluginMap, id);
            throw new IllegalArgumentException(helpMessage, e);
        }
    }
}

