/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.jackson;

import com.addthis.codec.jackson.BasicInjectableValues;
import com.addthis.codec.jackson.CodecJackson;
import com.addthis.codec.jackson.CodecModule;
import com.addthis.codec.jackson.DefaultCodecJackson;
import com.addthis.codec.plugins.PluginRegistry;
import com.addthis.codec.utils.ExecutorsModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.PropertyBindingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk7.Jdk7Module;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JSR310Module;
import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.validation.Validator;

@Beta
public final class Jackson {
    public static final ObjectMapper SIMPLE_MAPPER = new ObjectMapper();
    public static final JavaType NODE_TYPE = SIMPLE_MAPPER.constructType(JsonNode.class);
    private static final Splitter dotSplitter = Splitter.on((char)'.');

    private Jackson() {
    }

    public static ObjectMapper defaultMapper() {
        return DefaultCodecJackson.DEFAULT_MAPPER;
    }

    public static CodecJackson defaultCodec() {
        return DefaultCodecJackson.DEFAULT_CODEC;
    }

    public static Validator defaultValidator() {
        return DefaultCodecJackson.DEFAULT_VALIDATOR;
    }

    public static ObjectMapper newObjectMapper(PluginRegistry pluginRegistry) {
        CodecModule codecModule = new CodecModule(pluginRegistry);
        Config globalConfig = pluginRegistry.config();
        ObjectMapper objectMapper = new ObjectMapper();
        Jackson.toggleObjectMapperOptions(objectMapper);
        objectMapper.registerModule((Module)codecModule);
        Jackson.registerExtraModules(objectMapper);
        Jackson.allowCommentsAndUnquotedFields(objectMapper);
        objectMapper.setInjectableValues((InjectableValues)new BasicInjectableValues());
        return objectMapper;
    }

    public static ObjectMapper registerExtraModules(ObjectMapper objectMapper) {
        objectMapper.registerModule((Module)new GuavaModule());
        objectMapper.registerModule((Module)new Jdk7Module());
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.registerModule((Module)new JSR310Module());
        objectMapper.registerModule((Module)new JodaModule());
        objectMapper.registerModule((Module)new ExecutorsModule());
        return objectMapper;
    }

    public static ObjectMapper allowCommentsAndUnquotedFields(ObjectMapper objectMapper) {
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        return objectMapper;
    }

    public static ObjectMapper toggleObjectMapperOptions(ObjectMapper objectMapper) {
        objectMapper.disable(new MapperFeature[]{MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS});
        objectMapper.disable(new MapperFeature[]{MapperFeature.USE_GETTERS_AS_SETTERS});
        objectMapper.disable(new MapperFeature[]{MapperFeature.INFER_PROPERTY_MUTATORS});
        objectMapper.enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY);
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return objectMapper;
    }

    public static JsonNode configConverter(ConfigValue source) {
        return (JsonNode)SIMPLE_MAPPER.convertValue(source.unwrapped(), NODE_TYPE);
    }

    public static ObjectNode configConverter(ConfigObject source) {
        return (ObjectNode)SIMPLE_MAPPER.convertValue((Object)source.unwrapped(), NODE_TYPE);
    }

    public static void merge(ObjectNode primary, ObjectNode backup) {
        Iterator fieldNames = backup.fieldNames();
        while (fieldNames.hasNext()) {
            JsonNode backupValue;
            String fieldName = (String)fieldNames.next();
            JsonNode primaryValue = primary.get(fieldName);
            if (primaryValue == null) {
                backupValue = backup.get(fieldName).deepCopy();
                primary.set(fieldName, backupValue);
                continue;
            }
            if (!primaryValue.isObject() || !(backupValue = backup.get(fieldName)).isObject()) continue;
            Jackson.merge((ObjectNode)primaryValue, (ObjectNode)backupValue.deepCopy());
        }
    }

    public static void setAt(ObjectNode root, JsonNode value, String path) {
        if (path.indexOf(46) >= 0) {
            Iterator pathIterator = dotSplitter.split((CharSequence)path).iterator();
            while (pathIterator.hasNext()) {
                String nextPart = (String)pathIterator.next();
                if (pathIterator.hasNext()) {
                    root = root.with(nextPart);
                    continue;
                }
                root.set(nextPart, value);
            }
        } else {
            root.set(path, value);
        }
    }

    public static IOException maybeUnwrapPath(String pathToSkip, IOException cause) {
        JsonMappingException mappingException;
        List paths;
        if (pathToSkip != null && cause instanceof JsonMappingException && !(paths = (mappingException = (JsonMappingException)((Object)cause)).getPath()).isEmpty()) {
            Iterator pathIterator = dotSplitter.split((CharSequence)pathToSkip).iterator();
            Iterator refIterator = paths.iterator();
            while (pathIterator.hasNext()) {
                String pathToSkipPart = (String)pathIterator.next();
                if (!refIterator.hasNext()) {
                    return cause;
                }
                String nextRefField = ((JsonMappingException.Reference)refIterator.next()).getFieldName();
                if (pathToSkipPart.equals(nextRefField)) continue;
                return cause;
            }
            JsonMappingException unwrapped = new JsonMappingException(Jackson.rootMessage(mappingException), mappingException.getLocation(), mappingException.getCause());
            if (refIterator.hasNext()) {
                ArrayList remainingRefs = Lists.newArrayList(refIterator);
                for (JsonMappingException.Reference reference : Lists.reverse((List)remainingRefs)) {
                    unwrapped.prependPath(reference);
                }
            }
            return unwrapped;
        }
        return cause;
    }

    public static boolean isRealLocation(JsonLocation jsonLocation) {
        return jsonLocation != null && jsonLocation != JsonLocation.NA;
    }

    public static JsonMappingException maybeImproveLocation(JsonLocation wrapLoc, JsonMappingException cause) {
        JsonLocation exLoc = cause.getLocation();
        if (Jackson.isRealLocation(wrapLoc) && !Jackson.isRealLocation(exLoc)) {
            List paths;
            if (wrapLoc.getSourceRef() instanceof ConfigValue) {
                ConfigValue locRef = (ConfigValue)wrapLoc.getSourceRef();
                List paths2 = cause.getPath();
                for (JsonMappingException.Reference path : paths2) {
                    if (locRef instanceof ConfigObject) {
                        ConfigObject locRefObject = (ConfigObject)locRef;
                        String fieldName = path.getFieldName();
                        if (!locRefObject.containsKey((Object)fieldName)) break;
                        locRef = locRefObject.get((Object)fieldName);
                        continue;
                    }
                    if (!(locRef instanceof ConfigList)) break;
                    int fieldIndex = path.getIndex();
                    ConfigList locRefList = (ConfigList)locRef;
                    if (fieldIndex < 0 || locRefList.size() <= fieldIndex) break;
                    locRef = (ConfigValue)locRefList.get(fieldIndex);
                }
                if (locRef != wrapLoc.getSourceRef()) {
                    wrapLoc = Jackson.fromConfigValue(locRef);
                }
            }
            if (!(paths = Lists.reverse((List)cause.getPath())).isEmpty()) {
                JsonMappingException withLoc = new JsonMappingException(Jackson.rootMessage(cause), wrapLoc, (Throwable)cause);
                for (JsonMappingException.Reference path : paths) {
                    withLoc.prependPath(path);
                }
                return withLoc;
            }
            return new JsonMappingException(Jackson.rootMessage(cause), wrapLoc, (Throwable)cause);
        }
        return cause;
    }

    public static String rootMessage(JsonMappingException ex) {
        String rootMessage = ex.getOriginalMessage();
        if (ex instanceof PropertyBindingException) {
            String suffix = ((PropertyBindingException)ex).getMessageSuffix();
            if (rootMessage == null) {
                return suffix;
            }
            if (suffix != null) {
                return rootMessage + suffix;
            }
        }
        return rootMessage;
    }

    public static JsonLocation fromConfigValue(ConfigValue configValue) {
        ConfigOrigin configOrigin = configValue.origin();
        return new JsonLocation((Object)configValue, -1L, configOrigin.lineNumber(), -1);
    }

    public static JsonNode pathAt(ObjectNode root, String path) {
        if (path.indexOf(46) >= 0) {
            ObjectNode returnNode = root;
            for (String nextPart : dotSplitter.split((CharSequence)path)) {
                returnNode = returnNode.path(nextPart);
            }
            return returnNode;
        }
        return root.path(path);
    }
}

