/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.io.IOException;

public class WriteonlyPropertyIgnorer
extends DeserializationProblemHandler {
    public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser jp, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = jp.getCodec();
        if (objectCodec instanceof ObjectMapper) {
            ObjectMapper objectMapper = (ObjectMapper)objectCodec;
            BeanDescription beanDescription = objectMapper.getSerializationConfig().introspect(ctxt.constructType(beanOrClass.getClass()));
            for (BeanPropertyDefinition propertyDefinition : beanDescription.findProperties()) {
                if (!propertyName.equals(propertyDefinition.getName())) continue;
                jp.skipChildren();
                return true;
            }
        }
        return false;
    }
}

