/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.plugins;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class PluginMap {
    private static final Logger log = LoggerFactory.getLogger(PluginMap.class);
    public static final PluginMap EMPTY = new PluginMap();
    @Nonnull
    private final Config config;
    @Nonnull
    private final BiMap<String, Class<?>> map;
    @Nonnull
    private final Map<String, String> aliases;
    @Nonnull
    private final Set<String> inlinedAliases;
    @Nonnull
    private final String category;
    @Nonnull
    private final String classField;
    @Nullable
    private final Class<?> baseClass;

    public PluginMap(@Nonnull String category, @Nonnull Config config) {
        this.config = config;
        this.category = (String)Preconditions.checkNotNull((Object)category);
        this.classField = config.getString("_field");
        boolean errorMissing = config.getBoolean("_strict");
        if (config.hasPath("_class")) {
            String baseClassName = config.getString("_class");
            try {
                this.baseClass = Class.forName(baseClassName);
            }
            catch (ClassNotFoundException e) {
                log.error("could not find specified base class {} for category {}", (Object)baseClassName, (Object)category);
                throw new RuntimeException(e);
            }
        } else {
            this.baseClass = null;
        }
        Set labels = config.root().keySet();
        HashBiMap mutableMap = HashBiMap.create((int)labels.size());
        HashMap<String, String> mutableAliasMap = new HashMap<String, String>();
        HashSet<String> mutableInlinedAliasSet = new HashSet<String>();
        for (String label : labels) {
            String className;
            if (label.charAt(0) == '_' && !"_array".equals(label) && !"_default".equals(label)) continue;
            ConfigValue configValue = config.root().get((Object)label);
            if (configValue.valueType() == ConfigValueType.STRING) {
                className = (String)configValue.unwrapped();
            } else if (configValue.valueType() == ConfigValueType.OBJECT) {
                ConfigObject configObject = (ConfigObject)configValue;
                className = configObject.toConfig().getString("_class");
                if (configObject.toConfig().hasPath("_inline") && configObject.toConfig().getBoolean("_inline")) {
                    mutableInlinedAliasSet.add(label);
                }
            } else {
                if (configValue.valueType() == ConfigValueType.NULL) continue;
                throw new ConfigException.WrongType(configValue.origin(), label, "STRING OR OBJECT", configValue.valueType().toString());
            }
            if (labels.contains(className)) {
                mutableAliasMap.put(label, className);
                continue;
            }
            try {
                Class<?> foundClass = this.findAndValidateClass(className);
                mutableMap.put((Object)label, foundClass);
            }
            catch (ClassNotFoundException maybeSwallowed) {
                if (errorMissing) {
                    throw new RuntimeException(maybeSwallowed);
                }
                log.warn("plugin category {} with alias {} is pointing to missing class {}", new Object[]{category, label, className});
            }
        }
        this.map = Maps.unmodifiableBiMap((BiMap)mutableMap);
        this.aliases = Collections.unmodifiableMap(mutableAliasMap);
        this.checkAliasesForCycles();
        this.inlinedAliases = Collections.unmodifiableSet(mutableInlinedAliasSet);
    }

    private PluginMap() {
        this.config = ConfigFactory.empty();
        this.map = ImmutableBiMap.of();
        this.aliases = Collections.emptyMap();
        this.inlinedAliases = Collections.emptySet();
        this.classField = "class";
        this.category = "unknown";
        this.baseClass = null;
    }

    @Nonnull
    public BiMap<String, Class<?>> asBiMap() {
        return this.map;
    }

    @Nonnull
    public Config config() {
        return this.config;
    }

    @Nonnull
    public ConfigObject aliasDefaults(String alias) {
        ConfigValue configValue = this.config.root().get((Object)alias);
        ConfigObject defaults = configValue != null && configValue.valueType() == ConfigValueType.OBJECT ? (ConfigObject)configValue : ConfigFactory.empty().root();
        String aliasTarget = this.aliases.get(alias);
        if (aliasTarget != null) {
            defaults = defaults.withFallback((ConfigMergeable)this.aliasDefaults(aliasTarget));
        }
        return defaults;
    }

    @Nonnull
    public String classField() {
        return this.classField;
    }

    @Nonnull
    public String category() {
        return this.category;
    }

    @Nonnull
    public Set<String> inlinedAliases() {
        return this.inlinedAliases;
    }

    @Nullable
    public Class<?> arraySugar() {
        return this.getClassIfConfigured("_array");
    }

    @Nullable
    public Class<?> defaultSugar() {
        return this.getClassIfConfigured("_default");
    }

    @Nullable
    public Class<?> baseClass() {
        return this.baseClass;
    }

    @Nonnull
    public String getClassName(Class<?> type) {
        String alt = (String)this.map.inverse().get(type);
        if (alt != null) {
            return alt;
        }
        return type.getName();
    }

    @Nullable
    public String getLastAlias(String alias) {
        String aliasTarget = this.aliases.get(alias);
        if (aliasTarget != null) {
            return this.getLastAlias(aliasTarget);
        }
        if (this.asBiMap().containsKey((Object)alias)) {
            return alias;
        }
        return null;
    }

    @Nonnull
    public Class<?> getClass(String type) throws ClassNotFoundException {
        Class alt = (Class)this.map.get((Object)type);
        if (alt != null) {
            return alt;
        }
        String aliasTarget = this.aliases.get(type);
        if (aliasTarget != null) {
            return this.getClass(aliasTarget);
        }
        return this.findAndValidateClass(type);
    }

    @Nullable
    public Class<?> getClassIfConfigured(String type) {
        Class alt = (Class)this.map.get((Object)type);
        if (alt != null) {
            return alt;
        }
        String aliasTarget = this.aliases.get(type);
        if (aliasTarget != null) {
            return this.getClassIfConfigured(aliasTarget);
        }
        return null;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("category", (Object)this.category).add("baseClass", this.baseClass).add("classField", (Object)this.classField).add("map", this.map).add("aliases", this.aliases).add("inlined-aliases", this.inlinedAliases).toString();
    }

    @Nonnull
    private Class<?> findAndValidateClass(String className) throws ClassNotFoundException {
        Class<?> classValue = null;
        if (this.baseClass != null) {
            String packageName = this.baseClass.getPackage().getName();
            while (packageName != null && classValue == null) {
                String packageSugaredName = packageName + '.' + className;
                try {
                    classValue = Class.forName(packageSugaredName);
                }
                catch (ClassNotFoundException ignored) {
                    int lastDotIndex = packageName.lastIndexOf(46);
                    if (lastDotIndex >= 0) {
                        packageName = packageName.substring(0, lastDotIndex);
                        continue;
                    }
                    packageName = null;
                }
            }
        }
        if (classValue == null) {
            classValue = Class.forName(className);
        }
        if (this.baseClass != null && !this.baseClass.isAssignableFrom(classValue)) {
            throw new ClassCastException(String.format("plugin %s specified a base class %s and '%s: %s', is not a valid subtype", this.category, this.baseClass.getName(), this.classField, classValue.getName()));
        }
        return classValue;
    }

    private void checkAliasesForCycles() {
        for (String key : this.aliases.keySet()) {
            HashSet<String> visited = new HashSet<String>(this.aliases.size());
            this.checkAliasesForCyclesHelper(key, visited);
        }
    }

    private void checkAliasesForCyclesHelper(String key, Set<String> visited) {
        visited.add(key);
        String nextKey = this.aliases.get(key);
        if (nextKey == null) {
            return;
        }
        if (visited.contains(nextKey)) {
            throw new ConfigException.BadValue(this.config.root().get((Object)key).origin(), key, "cyclical aliases detected");
        }
        this.checkAliasesForCyclesHelper(nextKey, visited);
    }
}

