/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.reflection;

import com.addthis.codec.annotations.FieldConfig;
import com.addthis.codec.annotations.Pluggable;
import com.addthis.codec.plugins.PluginMap;
import com.addthis.codec.plugins.PluginRegistry;
import com.addthis.codec.reflection.CodableFieldInfo;
import com.addthis.codec.reflection.Fields;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSortedMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class CodableClassInfo {
    private static final Logger log = LoggerFactory.getLogger(CodableClassInfo.class);
    @Nonnull
    private final Class<?> baseClass;
    @Nonnull
    private final PluginMap pluginMap;
    @Nonnull
    private final Config fieldDefaults;
    @Nonnull
    private final ImmutableSortedMap<String, CodableFieldInfo> classData;

    public CodableClassInfo(@Nonnull Class<?> clazz) {
        this(clazz, ConfigFactory.load(), PluginRegistry.defaultRegistry());
    }

    public CodableClassInfo(@Nonnull Class<?> clazz, @Nonnull Config globalDefaults, @Nonnull PluginRegistry pluginRegistry) {
        if (Fields.isNative(clazz) || clazz.isArray()) {
            this.classData = ImmutableSortedMap.of();
            this.baseClass = clazz;
            this.pluginMap = PluginMap.EMPTY;
            this.fieldDefaults = ConfigFactory.empty();
            return;
        }
        Class<?> findBaseClass = clazz;
        PluginMap findPluginMap = PluginMap.EMPTY;
        for (Class<?> ptr = clazz; ptr != null; ptr = ptr.getSuperclass()) {
            if (pluginRegistry.byClass().containsKey(ptr)) {
                findPluginMap = pluginRegistry.byClass().get(ptr);
                findBaseClass = ptr;
                break;
            }
            Pluggable pluggable = ptr.getAnnotation(Pluggable.class);
            if (pluggable == null) continue;
            String category = pluggable.value();
            findPluginMap = pluginRegistry.asMap().get(category);
            findBaseClass = ptr;
            if (findPluginMap != null) break;
            log.warn("missing plugin map for {}, reached from {}", ptr, clazz);
            findPluginMap = PluginMap.EMPTY;
            break;
        }
        this.pluginMap = findPluginMap;
        this.baseClass = findBaseClass;
        HashMap<String, Field> fields = new HashMap<String, Field>();
        ConfigObject buildDefaults = ConfigFactory.empty().root();
        for (Class<?> ptrForFields = clazz; ptrForFields != null; ptrForFields = ptrForFields.getSuperclass()) {
            String canonicalClassName = ptrForFields.getCanonicalName();
            ConfigObject classDefaults = canonicalClassName != null && globalDefaults.hasPath(canonicalClassName) ? globalDefaults.getObject(canonicalClassName) : ConfigFactory.empty().root();
            for (Field field : ptrForFields.getDeclaredFields()) {
                if (fields.get(field.getName()) == null) {
                    fields.put(field.getName(), field);
                    continue;
                }
                classDefaults = classDefaults.withoutKey(field.getName());
                log.debug("({}) ignoring field in parent class ({}) with duplicate name ({})", new Object[]{clazz, ptrForFields, field.getName()});
            }
            for (Map.Entry pair : classDefaults.entrySet()) {
                if (buildDefaults.containsKey(pair.getKey())) continue;
                buildDefaults = buildDefaults.withValue((String)pair.getKey(), (ConfigValue)pair.getValue());
            }
        }
        this.fieldDefaults = buildDefaults.toConfig();
        Map<String, CodableFieldInfo> buildClassData = CodableClassInfo.buildFieldInfoMap(fields.values());
        this.classData = ImmutableSortedMap.naturalOrder().putAll(buildClassData).build();
    }

    @Nonnull
    public PluginMap getPluginMap() {
        return this.pluginMap;
    }

    @Nonnull
    public Config getFieldDefaults() {
        return this.fieldDefaults;
    }

    @Nonnull
    public Class<?> getBaseClass() {
        return this.baseClass;
    }

    @Nonnull
    public String getClassField() {
        return this.pluginMap.classField();
    }

    @Nullable
    public Class<?> getArraySugar() {
        return this.pluginMap.arraySugar();
    }

    @Nullable
    public Class<?> getDefaultSugar() {
        return this.pluginMap.defaultSugar();
    }

    @Nullable
    public String getClassName(Object val) {
        if (val.getClass() != this.baseClass) {
            return this.pluginMap.getClassName(val.getClass());
        }
        return null;
    }

    @Nonnull
    public Class<?> getClass(String name) throws ClassNotFoundException {
        return this.pluginMap.getClass(name);
    }

    public int size() {
        return this.classData.size();
    }

    @Nonnull
    public Collection<CodableFieldInfo> values() {
        return this.classData.values();
    }

    @Nonnull
    public Map<String, CodableFieldInfo> fields() {
        return this.classData;
    }

    private static boolean isCodable(Field field) {
        FieldConfig fieldConfigPolicy = field.getAnnotation(FieldConfig.class);
        if (fieldConfigPolicy != null) {
            return fieldConfigPolicy.codable();
        }
        int modifierBitSet = field.getModifiers();
        return !Modifier.isFinal(modifierBitSet) && Modifier.isPublic(modifierBitSet);
    }

    @Nonnull
    private static Map<String, CodableFieldInfo> buildFieldInfoMap(Iterable<Field> fields) {
        TreeMap<String, CodableFieldInfo> buildClassData = new TreeMap<String, CodableFieldInfo>();
        for (Field field : fields) {
            if (!CodableClassInfo.isCodable(field)) continue;
            CodableFieldInfo info = new CodableFieldInfo(field);
            buildClassData.put(field.getName(), info);
        }
        return buildClassData;
    }
}

