/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.reflection;

import com.addthis.codec.reflection.CodableClassInfo;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Fields {
    private static final ConcurrentMap<Class<?>, CodableClassInfo> fieldMaps = new ConcurrentHashMap();

    private Fields() {
    }

    public static CodableClassInfo getClassFieldMap(Class<?> clazz) {
        CodableClassInfo fieldMap = (CodableClassInfo)fieldMaps.get(clazz);
        if (fieldMap == null) {
            fieldMap = new CodableClassInfo(clazz);
            fieldMaps.put(clazz, fieldMap);
        }
        return fieldMap;
    }

    public static void flushClassFieldMaps() {
        fieldMaps.clear();
    }

    public static boolean isNative(@Nonnull Class<?> type) {
        return type == String.class || type == AtomicBoolean.class || type == Boolean.class || type.isPrimitive() || Number.class.isAssignableFrom(type);
    }

    @Nullable
    static Type[] collectTypes(Class<?> type, Type node) {
        int ni;
        ArrayList<Type> l = new ArrayList<Type>();
        Fields.collectTypes(l, type, node);
        while (!l.isEmpty() && (ni = l.lastIndexOf(null)) >= 0) {
            if (ni >= l.size() - 1) {
                l.remove(ni);
                continue;
            }
            l.set(ni, (Type)l.get(l.size() - 1));
            l.remove(l.size() - 1);
        }
        if (l.isEmpty()) {
            return null;
        }
        Type[] t = new Type[l.size()];
        l.toArray(t);
        return t;
    }

    private static void collectTypes(@Nonnull List<Type> list, @Nullable Class<?> type, @Nullable Type node) {
        if (type == null && node == null) {
            return;
        }
        if (node instanceof Class) {
            if (type != null) {
                Fields.collectTypes(list, ((Class)node).getSuperclass(), type.getGenericSuperclass());
            } else {
                Fields.collectTypes(list, ((Class)node).getSuperclass(), null);
            }
        } else if (type != null) {
            Fields.collectTypes(list, null, type.getGenericSuperclass());
        } else {
            Fields.collectTypes(list, null, null);
        }
        if (node instanceof ParameterizedType) {
            List<Type> tl = Arrays.asList(((ParameterizedType)node).getActualTypeArguments());
            for (Type t : tl) {
                if (t instanceof Class || t instanceof GenericArrayType) {
                    list.add(t);
                    continue;
                }
                if (t instanceof ParameterizedType) {
                    list.add(((ParameterizedType)t).getRawType());
                    continue;
                }
                list.add(null);
            }
        }
    }
}

