/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.codec.utils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

@JsonDeserialize(builder=ScheduledExecutorServiceBuilder.class)
@Beta
public class ScheduledExecutorServiceBuilder {
    private final ThreadFactory threadFactory;
    private final int coreThreads;
    private final boolean shutdownHook;

    @JsonCreator
    public ScheduledExecutorServiceBuilder(@JsonProperty(value="thread-factory") ThreadFactory threadFactory, @JsonProperty(value="core-threads") int coreThreads, @JsonProperty(value="shutdown-hook") boolean shutdownHook) {
        this.threadFactory = threadFactory;
        this.coreThreads = coreThreads;
        this.shutdownHook = shutdownHook;
    }

    public ScheduledExecutorService build() {
        ScheduledThreadPoolExecutor service = new ScheduledThreadPoolExecutor(this.coreThreads, this.threadFactory);
        if (this.shutdownHook) {
            return MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)service);
        }
        return service;
    }
}

