/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.metrics.reporter.config;

import com.addthis.metrics.reporter.config.AbstractHostPortReporterConfig;
import com.addthis.metrics.reporter.config.HostPort;
import java.net.InetAddress;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractGraphiteReporterConfig
extends AbstractHostPortReporterConfig {
    private static final Logger log = LoggerFactory.getLogger(AbstractGraphiteReporterConfig.class);
    @Valid
    private boolean udp;
    @Valid
    private boolean pickled;

    public AbstractGraphiteReporterConfig(InetAddress localhost) {
        super(localhost);
    }

    public AbstractGraphiteReporterConfig() {
    }

    public void setUdp(boolean udp) {
        this.udp = udp;
    }

    public boolean isUdp() {
        return this.udp;
    }

    public void setPickled(boolean pickled) {
        this.pickled = pickled;
    }

    public boolean isPickled() {
        return this.pickled;
    }

    @Override
    public List<HostPort> getFullHostList() {
        return this.getHostListAndStringList();
    }

    protected boolean setup(String className) {
        if (!this.isClassAvailable(className)) {
            log.error("Tried to enable GraphiteReporter, but class {} was not found", (Object)className);
            return false;
        }
        List<HostPort> hosts = this.getFullHostList();
        if (hosts == null || hosts.isEmpty()) {
            log.error("No hosts specified, cannot enable GraphiteReporter");
            return false;
        }
        return true;
    }
}

