/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.metrics.reporter.config;

import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

public class PredicateConfig {
    @NotNull
    @Pattern(regexp="^(white|black)$", message="must one of: white, black")
    private String color;
    @NotNull
    @Size(min=1)
    private List<String> patterns;
    private boolean useQualifiedName;
    private Measurement meter;
    private Measurement histogram;
    private Measurement timer;
    private List<java.util.regex.Pattern> cPatterns;
    private List<MeasurementPattern> meterPatterns;
    private List<MeasurementPattern> histogramPatterns;
    private List<MeasurementPattern> timerPatterns;

    public PredicateConfig() {
    }

    public PredicateConfig(String color, List<String> patterns) {
        this(color, patterns, false);
    }

    public PredicateConfig(String color, List<String> patterns, boolean useQualifiedName) {
        this.setColor(color);
        this.setPatterns(patterns);
        this.setUseQualifiedName(useQualifiedName);
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(List<String> patterns) {
        this.patterns = patterns;
        this.cPatterns = new ArrayList<java.util.regex.Pattern>();
        for (String s : patterns) {
            this.cPatterns.add(java.util.regex.Pattern.compile(s));
        }
    }

    public boolean getUseQualifiedName() {
        return this.useQualifiedName;
    }

    public void setUseQualifiedName(boolean useQualifiedName) {
        this.useQualifiedName = useQualifiedName;
    }

    public Measurement getMeter() {
        return this.meter;
    }

    public Measurement getHistogram() {
        return this.histogram;
    }

    public Measurement getTimer() {
        return this.timer;
    }

    public void setMeter(Measurement meter) {
        this.meter = meter;
        this.meterPatterns = this.createMeasurementPatterns(meter);
    }

    public void setHistogram(Measurement histogram) {
        this.histogram = histogram;
        this.histogramPatterns = this.createMeasurementPatterns(histogram);
    }

    public void setTimer(Measurement timer) {
        this.timer = timer;
        this.timerPatterns = this.createMeasurementPatterns(timer);
    }

    private List<MeasurementPattern> createMeasurementPatterns(Measurement measurement) {
        ArrayList<MeasurementPattern> result = null;
        if (measurement != null) {
            result = new ArrayList<MeasurementPattern>();
            for (MeasurementSpecification s : measurement.patterns) {
                result.add(new MeasurementPattern(s.metric, s.measure));
            }
        }
        return result;
    }

    public boolean allowString(String name) {
        if (this.color.equals("black")) {
            for (java.util.regex.Pattern pat : this.cPatterns) {
                if (!pat.matcher(name).matches()) continue;
                return false;
            }
            return true;
        }
        if (this.color.equals("white")) {
            for (java.util.regex.Pattern pat : this.cPatterns) {
                if (!pat.matcher(name).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean allowMeasurement(String name, String measurement, Measurement type, List<MeasurementPattern> patterns) {
        if (type.color.equals("black")) {
            for (int i = 0; i < patterns.size(); ++i) {
                java.util.regex.Pattern metricPattern = patterns.get(i).metric;
                java.util.regex.Pattern measurePattern = patterns.get(i).measure;
                if (!metricPattern.matcher(name).matches() || !measurePattern.matcher(measurement).matches()) continue;
                return false;
            }
            return true;
        }
        if (type.color.equals("white")) {
            for (int i = 0; i < patterns.size(); ++i) {
                java.util.regex.Pattern metricPattern = patterns.get(i).metric;
                java.util.regex.Pattern measurePattern = patterns.get(i).measure;
                if (!metricPattern.matcher(name).matches() || !measurePattern.matcher(measurement).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public List<MeasurementPattern> getMeterPatterns() {
        return this.meterPatterns;
    }

    public List<MeasurementPattern> getHistogramPatterns() {
        return this.histogramPatterns;
    }

    public List<MeasurementPattern> getTimerPatterns() {
        return this.timerPatterns;
    }

    public static class MeasurementPattern {
        @NotNull
        private java.util.regex.Pattern metric;
        @NotNull
        private java.util.regex.Pattern measure;

        public MeasurementPattern(String metric, String measure) {
            this.metric = java.util.regex.Pattern.compile(metric);
            this.measure = java.util.regex.Pattern.compile(measure);
        }
    }

    public static class MeasurementSpecification {
        @NotNull
        private String metric;
        @NotNull
        private String measure;

        public String getMetric() {
            return this.metric;
        }

        public String getMeasure() {
            return this.measure;
        }

        public void setMetric(String metric) {
            this.metric = metric;
        }

        public void setMeasure(String measure) {
            this.measure = measure;
        }
    }

    public static class Measurement {
        @NotNull
        @Pattern(regexp="^(white|black)$", message="must one of: white, black")
        private String color;
        @NotNull
        @Size(min=1)
        private List<MeasurementSpecification> patterns;
        private boolean useQualifiedName;

        public Measurement() {
        }

        public Measurement(String color, boolean useQualifiedName) {
            this.color = color;
            this.useQualifiedName = useQualifiedName;
        }

        public String getColor() {
            return this.color;
        }

        public boolean getUseQualifiedName() {
            return this.useQualifiedName;
        }

        public List<MeasurementSpecification> getPatterns() {
            return this.patterns;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public void setUseQualifiedName(boolean value) {
            this.useQualifiedName = value;
        }

        public void setPatterns(List<MeasurementSpecification> patterns) {
            this.patterns = patterns;
        }
    }
}

