/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cloudsearchdomain.model.SuggestRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.UriResourcePathUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SuggestRequestMarshaller
implements Marshaller<Request<SuggestRequest>, SuggestRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SuggestRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<SuggestRequest> marshall(SuggestRequest suggestRequest) {
        if (suggestRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)suggestRequest, "AmazonCloudSearchDomain");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-01-01/suggest?format=sdk&pretty=true";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        request.setResourcePath(uriResourcePath);
        if (suggestRequest.getQuery() != null) {
            request.addParameter("q", StringUtils.fromString((String)suggestRequest.getQuery()));
        }
        if (suggestRequest.getSuggester() != null) {
            request.addParameter("suggester", StringUtils.fromString((String)suggestRequest.getSuggester()));
        }
        if (suggestRequest.getSize() != null) {
            request.addParameter("size", StringUtils.fromLong((Long)suggestRequest.getSize()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

