/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudtrail.model.Event;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class EventMarshaller {
    private static final MarshallingInfo<String> EVENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventId").build();
    private static final MarshallingInfo<String> EVENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventName").build();
    private static final MarshallingInfo<Date> EVENTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventTime").build();
    private static final MarshallingInfo<String> EVENTSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventSource").build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").build();
    private static final MarshallingInfo<List> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resources").build();
    private static final MarshallingInfo<String> CLOUDTRAILEVENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudTrailEvent").build();
    private static final EventMarshaller instance = new EventMarshaller();

    public static EventMarshaller getInstance() {
        return instance;
    }

    public void marshall(Event event, ProtocolMarshaller protocolMarshaller) {
        if (event == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)event.getEventId(), EVENTID_BINDING);
            protocolMarshaller.marshall((Object)event.getEventName(), EVENTNAME_BINDING);
            protocolMarshaller.marshall((Object)event.getEventTime(), EVENTTIME_BINDING);
            protocolMarshaller.marshall((Object)event.getEventSource(), EVENTSOURCE_BINDING);
            protocolMarshaller.marshall((Object)event.getUsername(), USERNAME_BINDING);
            protocolMarshaller.marshall(event.getResources(), RESOURCES_BINDING);
            protocolMarshaller.marshall((Object)event.getCloudTrailEvent(), CLOUDTRAILEVENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

