/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverted;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@DynamoDB
@DynamoDBTypeConverted(converter=Converter.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface DynamoDBMarshalling {
    public Class<? extends DynamoDBMarshaller<? extends Object>> marshallerClass();

    public static final class Converter<T>
    implements DynamoDBTypeConverter<String, T> {
        private final Class<DynamoDBMarshaller<T>> marshallerClass;
        private final Class<T> targetType;

        public Converter(Class<T> targetType, DynamoDBMarshalling annotation) {
            this.marshallerClass = annotation.marshallerClass();
            this.targetType = targetType;
        }

        @Override
        public final String convert(T object) {
            return this.marshaller().marshall(object);
        }

        @Override
        public final T unconvert(String object) {
            return this.marshaller().unmarshall(this.targetType, object);
        }

        private DynamoDBMarshaller<T> marshaller() {
            try {
                return this.marshallerClass.newInstance();
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("Unable to instantiate marshaller " + this.marshallerClass, e);
            }
        }
    }
}

