/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InvokeRequestMarshaller
implements Marshaller<Request<InvokeRequest>, InvokeRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    public Request<InvokeRequest> marshall(InvokeRequest invokeRequest) {
        String value;
        String name;
        if (invokeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)invokeRequest, "AWSLambda");
        String target = "AWSLambda.Invoke";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        if (invokeRequest.getInvocationType() != null) {
            request.addHeader("X-Amz-Invocation-Type", StringUtils.fromString((String)invokeRequest.getInvocationType()));
        }
        if (invokeRequest.getLogType() != null) {
            request.addHeader("X-Amz-Log-Type", StringUtils.fromString((String)invokeRequest.getLogType()));
        }
        if (invokeRequest.getClientContext() != null) {
            request.addHeader("X-Amz-Client-Context", StringUtils.fromString((String)invokeRequest.getClientContext()));
        }
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("FunctionName")) {
            name = DYNAMIC_QUERY_PARAMS.get("FunctionName");
            String string = value = invokeRequest.getFunctionName() == null ? null : StringUtils.fromString((String)invokeRequest.getFunctionName());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{FunctionName}", invokeRequest.getFunctionName() == null ? "" : StringUtils.fromString((String)invokeRequest.getFunctionName()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Qualifier")) {
            name = DYNAMIC_QUERY_PARAMS.get("Qualifier");
            String string = value = invokeRequest.getQualifier() == null ? null : StringUtils.fromString((String)invokeRequest.getQualifier());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Qualifier}", invokeRequest.getQualifier() == null ? "" : StringUtils.fromString((String)invokeRequest.getQualifier()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        request.setContent((InputStream)BinaryUtils.toStream((ByteBuffer)invokeRequest.getPayload()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }

    static {
        String path = "/2015-03-31/functions/{FunctionName}/invocations?Qualifier={Qualifier}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

