/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicequotas.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.servicequotas.model.ServiceQuota;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListServiceQuotasResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ServiceQuota> quotas;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListServiceQuotasResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ServiceQuota> getQuotas() {
        return this.quotas;
    }

    public void setQuotas(Collection<ServiceQuota> quotas) {
        if (quotas == null) {
            this.quotas = null;
            return;
        }
        this.quotas = new ArrayList<ServiceQuota>(quotas);
    }

    public ListServiceQuotasResult withQuotas(ServiceQuota ... quotas) {
        if (this.quotas == null) {
            this.setQuotas(new ArrayList<ServiceQuota>(quotas.length));
        }
        for (ServiceQuota ele : quotas) {
            this.quotas.add(ele);
        }
        return this;
    }

    public ListServiceQuotasResult withQuotas(Collection<ServiceQuota> quotas) {
        this.setQuotas(quotas);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getQuotas() != null) {
            sb.append("Quotas: ").append(this.getQuotas());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceQuotasResult)) {
            return false;
        }
        ListServiceQuotasResult other = (ListServiceQuotasResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getQuotas() == null ^ this.getQuotas() == null) {
            return false;
        }
        return other.getQuotas() == null || other.getQuotas().equals(this.getQuotas());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getQuotas() == null ? 0 : this.getQuotas().hashCode());
        return hashCode;
    }

    public ListServiceQuotasResult clone() {
        try {
            return (ListServiceQuotasResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

