/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListDocumentsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<DocumentFilter> documentFilterList;
    private Integer maxResults;
    private String nextToken;

    public List<DocumentFilter> getDocumentFilterList() {
        if (this.documentFilterList == null) {
            this.documentFilterList = new SdkInternalList();
        }
        return this.documentFilterList;
    }

    public void setDocumentFilterList(Collection<DocumentFilter> documentFilterList) {
        if (documentFilterList == null) {
            this.documentFilterList = null;
            return;
        }
        this.documentFilterList = new SdkInternalList(documentFilterList);
    }

    public ListDocumentsRequest withDocumentFilterList(DocumentFilter ... documentFilterList) {
        if (this.documentFilterList == null) {
            this.setDocumentFilterList((Collection<DocumentFilter>)new SdkInternalList(documentFilterList.length));
        }
        for (DocumentFilter ele : documentFilterList) {
            this.documentFilterList.add((Object)ele);
        }
        return this;
    }

    public ListDocumentsRequest withDocumentFilterList(Collection<DocumentFilter> documentFilterList) {
        this.setDocumentFilterList(documentFilterList);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListDocumentsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListDocumentsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentFilterList() != null) {
            sb.append("DocumentFilterList: ").append(this.getDocumentFilterList()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentsRequest)) {
            return false;
        }
        ListDocumentsRequest other = (ListDocumentsRequest)obj;
        if (other.getDocumentFilterList() == null ^ this.getDocumentFilterList() == null) {
            return false;
        }
        if (other.getDocumentFilterList() != null && !other.getDocumentFilterList().equals(this.getDocumentFilterList())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentFilterList() == null ? 0 : this.getDocumentFilterList().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListDocumentsRequest clone() {
        return (ListDocumentsRequest)super.clone();
    }
}

