/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.xray.model.ServiceStatistics;

@SdkInternalApi
public class ServiceStatisticsMarshaller {
    private static final MarshallingInfo<Long> OKCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OkCount").build();
    private static final MarshallingInfo<StructuredPojo> ERRORSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorStatistics").build();
    private static final MarshallingInfo<StructuredPojo> FAULTSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FaultStatistics").build();
    private static final MarshallingInfo<Long> TOTALCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalCount").build();
    private static final MarshallingInfo<Double> TOTALRESPONSETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalResponseTime").build();
    private static final ServiceStatisticsMarshaller instance = new ServiceStatisticsMarshaller();

    public static ServiceStatisticsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ServiceStatistics serviceStatistics, ProtocolMarshaller protocolMarshaller) {
        if (serviceStatistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)serviceStatistics.getOkCount(), OKCOUNT_BINDING);
            protocolMarshaller.marshall((Object)serviceStatistics.getErrorStatistics(), ERRORSTATISTICS_BINDING);
            protocolMarshaller.marshall((Object)serviceStatistics.getFaultStatistics(), FAULTSTATISTICS_BINDING);
            protocolMarshaller.marshall((Object)serviceStatistics.getTotalCount(), TOTALCOUNT_BINDING);
            protocolMarshaller.marshall((Object)serviceStatistics.getTotalResponseTime(), TOTALRESPONSETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

