/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.Signer;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.services.dynamodb.AmazonDynamoDB;
import com.amazonaws.services.dynamodb.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodb.model.BatchGetItemResult;
import com.amazonaws.services.dynamodb.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodb.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodb.model.CreateTableRequest;
import com.amazonaws.services.dynamodb.model.CreateTableResult;
import com.amazonaws.services.dynamodb.model.DeleteItemRequest;
import com.amazonaws.services.dynamodb.model.DeleteItemResult;
import com.amazonaws.services.dynamodb.model.DeleteTableRequest;
import com.amazonaws.services.dynamodb.model.DeleteTableResult;
import com.amazonaws.services.dynamodb.model.DescribeTableRequest;
import com.amazonaws.services.dynamodb.model.DescribeTableResult;
import com.amazonaws.services.dynamodb.model.GetItemRequest;
import com.amazonaws.services.dynamodb.model.GetItemResult;
import com.amazonaws.services.dynamodb.model.ListTablesRequest;
import com.amazonaws.services.dynamodb.model.ListTablesResult;
import com.amazonaws.services.dynamodb.model.PutItemRequest;
import com.amazonaws.services.dynamodb.model.PutItemResult;
import com.amazonaws.services.dynamodb.model.QueryRequest;
import com.amazonaws.services.dynamodb.model.QueryResult;
import com.amazonaws.services.dynamodb.model.ScanRequest;
import com.amazonaws.services.dynamodb.model.ScanResult;
import com.amazonaws.services.dynamodb.model.UpdateItemRequest;
import com.amazonaws.services.dynamodb.model.UpdateItemResult;
import com.amazonaws.services.dynamodb.model.UpdateTableRequest;
import com.amazonaws.services.dynamodb.model.UpdateTableResult;
import com.amazonaws.services.dynamodb.model.transform.BatchGetItemRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.BatchGetItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.BatchWriteItemRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.BatchWriteItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.ConditionalCheckFailedExceptionUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.CreateTableRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.CreateTableResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.DeleteItemRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.DeleteItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.DeleteTableRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.DeleteTableResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.DescribeTableRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.DescribeTableResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.GetItemRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.GetItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.ListTablesRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.ListTablesResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.ProvisionedThroughputExceededExceptionUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.PutItemRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.PutItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.QueryRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.QueryResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.ResourceInUseExceptionUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.ScanRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.ScanResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.UpdateItemRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.UpdateItemResultJsonUnmarshaller;
import com.amazonaws.services.dynamodb.model.transform.UpdateTableRequestMarshaller;
import com.amazonaws.services.dynamodb.model.transform.UpdateTableResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class AmazonDynamoDBClient
extends AmazonWebServiceClient
implements AmazonDynamoDB {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonDynamoDB.class);
    protected List<JsonErrorUnmarshaller> exceptionUnmarshallers;
    private AWS4Signer signer;

    public AmazonDynamoDBClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonDynamoDBClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonDynamoDBClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonDynamoDBClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        this(awsCredentials, clientConfiguration, null);
    }

    public AmazonDynamoDBClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonDynamoDBClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonDynamoDBClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonDynamoDBClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonDynamoDBClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonDynamoDBClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalServerErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ProvisionedThroughputExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ResourceInUseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ConditionalCheckFailedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("dynamodb.us-east-1.amazonaws.com/");
        this.signer = new AWS4Signer();
        this.signer.setServiceName("dynamodb");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/dynamodb/request.handlers"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        if (config.getRetryPolicy() == PredefinedRetryPolicies.DEFAULT) {
            config = new ClientConfiguration(orig);
            config.setRetryPolicy(PredefinedRetryPolicies.DYNAMODB_DEFAULT);
        }
        return config;
    }

    @Override
    public ListTablesResult listTables(ListTablesRequest listTablesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(listTablesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListTablesRequest> request = this.marshall(listTablesRequest, new ListTablesRequestMarshaller(), executionContext.getAwsRequestMetrics());
        request.setAWSRequestMetrics(awsRequestMetrics);
        ListTablesResultJsonUnmarshaller unmarshaller = new ListTablesResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (ListTablesResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
    }

    @Override
    public QueryResult query(QueryRequest queryRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(queryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<QueryRequest> request = this.marshall(queryRequest, new QueryRequestMarshaller(), executionContext.getAwsRequestMetrics());
        request.setAWSRequestMetrics(awsRequestMetrics);
        QueryResultJsonUnmarshaller unmarshaller = new QueryResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (QueryResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
    }

    @Override
    public BatchWriteItemResult batchWriteItem(BatchWriteItemRequest batchWriteItemRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(batchWriteItemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<BatchWriteItemRequest> request = this.marshall(batchWriteItemRequest, new BatchWriteItemRequestMarshaller(), executionContext.getAwsRequestMetrics());
        request.setAWSRequestMetrics(awsRequestMetrics);
        BatchWriteItemResultJsonUnmarshaller unmarshaller = new BatchWriteItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (BatchWriteItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
    }

    @Override
    public UpdateItemResult updateItem(UpdateItemRequest updateItemRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(updateItemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateItemRequest> request = this.marshall(updateItemRequest, new UpdateItemRequestMarshaller(), executionContext.getAwsRequestMetrics());
        request.setAWSRequestMetrics(awsRequestMetrics);
        UpdateItemResultJsonUnmarshaller unmarshaller = new UpdateItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (UpdateItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
    }

    @Override
    public PutItemResult putItem(PutItemRequest putItemRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(putItemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<PutItemRequest> request = this.marshall(putItemRequest, new PutItemRequestMarshaller(), executionContext.getAwsRequestMetrics());
        request.setAWSRequestMetrics(awsRequestMetrics);
        PutItemResultJsonUnmarshaller unmarshaller = new PutItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (PutItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
    }

    @Override
    public DescribeTableResult describeTable(DescribeTableRequest describeTableRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(describeTableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeTableRequest> request = this.marshall(describeTableRequest, new DescribeTableRequestMarshaller(), executionContext.getAwsRequestMetrics());
        request.setAWSRequestMetrics(awsRequestMetrics);
        DescribeTableResultJsonUnmarshaller unmarshaller = new DescribeTableResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (DescribeTableResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
    }

    @Override
    public ScanResult scan(ScanRequest scanRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(scanRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ScanRequest> request = this.marshall(scanRequest, new ScanRequestMarshaller(), executionContext.getAwsRequestMetrics());
        request.setAWSRequestMetrics(awsRequestMetrics);
        ScanResultJsonUnmarshaller unmarshaller = new ScanResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (ScanResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
    }

    @Override
    public CreateTableResult createTable(CreateTableRequest createTableRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(createTableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateTableRequest> request = this.marshall(createTableRequest, new CreateTableRequestMarshaller(), executionContext.getAwsRequestMetrics());
        request.setAWSRequestMetrics(awsRequestMetrics);
        CreateTableResultJsonUnmarshaller unmarshaller = new CreateTableResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (CreateTableResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
    }

    @Override
    public UpdateTableResult updateTable(UpdateTableRequest updateTableRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(updateTableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateTableRequest> request = this.marshall(updateTableRequest, new UpdateTableRequestMarshaller(), executionContext.getAwsRequestMetrics());
        request.setAWSRequestMetrics(awsRequestMetrics);
        UpdateTableResultJsonUnmarshaller unmarshaller = new UpdateTableResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (UpdateTableResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
    }

    @Override
    public DeleteTableResult deleteTable(DeleteTableRequest deleteTableRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(deleteTableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteTableRequest> request = this.marshall(deleteTableRequest, new DeleteTableRequestMarshaller(), executionContext.getAwsRequestMetrics());
        request.setAWSRequestMetrics(awsRequestMetrics);
        DeleteTableResultJsonUnmarshaller unmarshaller = new DeleteTableResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (DeleteTableResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
    }

    @Override
    public DeleteItemResult deleteItem(DeleteItemRequest deleteItemRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(deleteItemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteItemRequest> request = this.marshall(deleteItemRequest, new DeleteItemRequestMarshaller(), executionContext.getAwsRequestMetrics());
        request.setAWSRequestMetrics(awsRequestMetrics);
        DeleteItemResultJsonUnmarshaller unmarshaller = new DeleteItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (DeleteItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
    }

    @Override
    public GetItemResult getItem(GetItemRequest getItemRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(getItemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetItemRequest> request = this.marshall(getItemRequest, new GetItemRequestMarshaller(), executionContext.getAwsRequestMetrics());
        request.setAWSRequestMetrics(awsRequestMetrics);
        GetItemResultJsonUnmarshaller unmarshaller = new GetItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (GetItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
    }

    @Override
    public BatchGetItemResult batchGetItem(BatchGetItemRequest batchGetItemRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(batchGetItemRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<BatchGetItemRequest> request = this.marshall(batchGetItemRequest, new BatchGetItemRequestMarshaller(), executionContext.getAwsRequestMetrics());
        request.setAWSRequestMetrics(awsRequestMetrics);
        BatchGetItemResultJsonUnmarshaller unmarshaller = new BatchGetItemResultJsonUnmarshaller();
        JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
        return (BatchGetItemResult)this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
    }

    @Override
    public ListTablesResult listTables() throws AmazonServiceException, AmazonClientException {
        return this.listTables(new ListTablesRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    protected String getServiceAbbreviation() {
        return "dynamodb";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) throws AmazonClientException {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner((Signer)this.signer);
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        Response result = this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
        awsRequestMetrics.log();
        return (X)result.getAwsResponse();
    }

    private <T extends AmazonWebServiceRequest> Request<T> marshall(T awsRequest, Marshaller<Request<T>, T> marshaller, AWSRequestMetrics awsRequestMetrics) {
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            Request request = (Request)marshaller.marshall(awsRequest);
            return request;
        }
        catch (AmazonClientException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AmazonClientException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
        }
    }
}

