/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.transfer;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.SDKProgressPublisher;
import com.amazonaws.internal.ResettableInputStream;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.glacier.AmazonGlacier;
import com.amazonaws.services.glacier.AmazonGlacierClient;
import com.amazonaws.services.glacier.TreeHashGenerator;
import com.amazonaws.services.glacier.internal.TreeHashInputStream;
import com.amazonaws.services.glacier.model.AbortMultipartUploadRequest;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadResult;
import com.amazonaws.services.glacier.model.DescribeJobRequest;
import com.amazonaws.services.glacier.model.DescribeJobResult;
import com.amazonaws.services.glacier.model.GetJobOutputRequest;
import com.amazonaws.services.glacier.model.GetJobOutputResult;
import com.amazonaws.services.glacier.model.InitiateJobRequest;
import com.amazonaws.services.glacier.model.InitiateJobResult;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadResult;
import com.amazonaws.services.glacier.model.JobParameters;
import com.amazonaws.services.glacier.model.UploadArchiveRequest;
import com.amazonaws.services.glacier.model.UploadArchiveResult;
import com.amazonaws.services.glacier.model.UploadMultipartPartRequest;
import com.amazonaws.services.glacier.transfer.JobStatusMonitor;
import com.amazonaws.services.glacier.transfer.UploadResult;
import com.amazonaws.services.s3.internal.InputSubstream;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.Throwables;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArchiveTransferManager {
    private static final long MAXIMUM_UPLOAD_PART_SIZE = 0x100000000L;
    private static final long DEFAULT_DOWNLOAD_CHUNK_SIZE = 0x8000000L;
    private static final long MINIMUM_PART_SIZE = 0x100000L;
    private static final long MULTIPART_UPLOAD_SIZE_THRESHOLD = 0x6400000L;
    private static final int DEFAULT_MAX_RETRIES = 3;
    private final AmazonGlacier glacier;
    private final AWSCredentialsProvider credentialsProvider;
    private final ClientConfiguration clientConfiguration;
    private final AmazonSQSClient sqs;
    private final AmazonSNSClient sns;
    private static final Log log = LogFactory.getLog(ArchiveTransferManager.class);

    public ArchiveTransferManager(AWSCredentials credentials) {
        this((AWSCredentialsProvider)new StaticCredentialsProvider(credentials), new ClientConfiguration());
    }

    public ArchiveTransferManager(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this(new AmazonGlacierClient(credentialsProvider, clientConfiguration), credentialsProvider, clientConfiguration);
    }

    public ArchiveTransferManager(AmazonGlacierClient glacier, AWSCredentialsProvider credentialsProvider) {
        this(glacier, credentialsProvider, new ClientConfiguration());
    }

    public ArchiveTransferManager(AmazonGlacierClient glacier, AWSCredentials credentials) {
        this(glacier, (AWSCredentialsProvider)new StaticCredentialsProvider(credentials), new ClientConfiguration());
    }

    public ArchiveTransferManager(AmazonGlacierClient glacier, AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this.credentialsProvider = credentialsProvider;
        this.clientConfiguration = clientConfiguration;
        this.glacier = glacier;
        this.sns = null;
        this.sqs = null;
    }

    public ArchiveTransferManager(AmazonGlacierClient glacier, AmazonSQSClient sqs, AmazonSNSClient sns) {
        this.credentialsProvider = null;
        this.clientConfiguration = null;
        this.glacier = glacier;
        this.sqs = sqs;
        this.sns = sns;
    }

    public UploadResult upload(String vaultName, String archiveDescription, File file) throws AmazonServiceException, AmazonClientException, FileNotFoundException {
        return this.upload(null, vaultName, archiveDescription, file);
    }

    public UploadResult upload(String accountId, String vaultName, String archiveDescription, File file) throws AmazonServiceException, AmazonClientException, FileNotFoundException {
        return this.upload(accountId, vaultName, archiveDescription, file, null);
    }

    public UploadResult upload(String accountId, String vaultName, String archiveDescription, File file, ProgressListener progressListener) throws AmazonServiceException, AmazonClientException {
        if (file.length() > 0x6400000L) {
            return this.uploadInMultipleParts(accountId, vaultName, archiveDescription, file, progressListener);
        }
        return this.uploadInSinglePart(accountId, vaultName, archiveDescription, file, progressListener);
    }

    public void download(String vaultName, String archiveId, File file) throws AmazonServiceException, AmazonClientException {
        this.download(null, vaultName, archiveId, file);
    }

    public void download(String accountId, String vaultName, String archiveId, File file) throws AmazonServiceException, AmazonClientException {
        this.download(accountId, vaultName, archiveId, file, null);
    }

    public void download(String accountId, String vaultName, String archiveId, File file, ProgressListener progressListener) throws AmazonServiceException, AmazonClientException {
        JobStatusMonitor jobStatusMonitor = null;
        String jobId = null;
        SDKProgressPublisher.publishProgress((ProgressListener)progressListener, (ProgressEventType)ProgressEventType.TRANSFER_PREPARING_EVENT);
        try {
            jobStatusMonitor = this.credentialsProvider != null && this.clientConfiguration != null ? new JobStatusMonitor(this.credentialsProvider, this.clientConfiguration) : new JobStatusMonitor(this.sqs, this.sns);
            JobParameters jobParameters = new JobParameters().withArchiveId(archiveId).withType("archive-retrieval").withSNSTopic(jobStatusMonitor.getTopicArn());
            InitiateJobResult archiveRetrievalResult = this.glacier.initiateJob(new InitiateJobRequest().withAccountId(accountId).withVaultName(vaultName).withJobParameters(jobParameters));
            jobId = archiveRetrievalResult.getJobId();
            jobStatusMonitor.waitForJobToComplete(jobId);
        }
        catch (Throwable t) {
            SDKProgressPublisher.publishProgress((ProgressListener)progressListener, (ProgressEventType)ProgressEventType.TRANSFER_FAILED_EVENT);
            throw Throwables.failure((Throwable)t);
        }
        finally {
            if (jobStatusMonitor != null) {
                jobStatusMonitor.shutdown();
            }
        }
        this.downloadJobOutput(accountId, vaultName, jobId, file, progressListener);
    }

    public void downloadJobOutput(String accountId, String vaultName, String jobId, File file) {
        this.downloadJobOutput(accountId, vaultName, jobId, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadJobOutput(String accountId, String vaultName, String jobId, File file, ProgressListener progressListener) {
        long archiveSize = 0L;
        long chunkSize = 0x8000000L;
        long currentPosition = 0L;
        long endPosition = 0L;
        RandomAccessFile output = null;
        String customizedChunkSize = null;
        customizedChunkSize = System.getProperty("com.amazonaws.services.glacier.transfer.downloadChunkSizeInMB");
        DescribeJobResult describeJobResult = this.glacier.describeJob(new DescribeJobRequest(accountId, vaultName, jobId));
        archiveSize = describeJobResult.getArchiveSizeInBytes();
        if (customizedChunkSize != null) {
            try {
                chunkSize = Long.parseLong(customizedChunkSize) * 1024L * 1024L;
            }
            catch (NumberFormatException e) {
                SDKProgressPublisher.publishProgress((ProgressListener)progressListener, (ProgressEventType)ProgressEventType.TRANSFER_FAILED_EVENT);
                throw new AmazonClientException("Invalid chunk size: " + e.getMessage());
            }
            this.validateChunkSize(chunkSize);
        }
        try {
            output = new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException e) {
            SDKProgressPublisher.publishProgress((ProgressListener)progressListener, (ProgressEventType)ProgressEventType.TRANSFER_FAILED_EVENT);
            throw new AmazonClientException("Unable to open the output file " + file.getPath(), (Throwable)e);
        }
        try {
            SDKProgressPublisher.publishProgress((ProgressListener)progressListener, (ProgressEventType)ProgressEventType.TRANSFER_STARTED_EVENT);
            while (currentPosition < archiveSize) {
                endPosition = currentPosition + chunkSize > archiveSize ? archiveSize - 1L : currentPosition + chunkSize - 1L;
                try {
                    this.downloadOneChunk(accountId, vaultName, jobId, output, currentPosition, endPosition, progressListener);
                }
                catch (Throwable t) {
                    SDKProgressPublisher.publishProgress((ProgressListener)progressListener, (ProgressEventType)ProgressEventType.TRANSFER_FAILED_EVENT);
                    throw Throwables.failure((Throwable)t);
                }
                currentPosition += chunkSize;
            }
            SDKProgressPublisher.publishProgress((ProgressListener)progressListener, (ProgressEventType)ProgressEventType.TRANSFER_COMPLETED_EVENT);
        }
        finally {
            IOUtils.closeQuietly((Closeable)output, (Log)log);
        }
    }

    private void validateChunkSize(long chunkSize) {
        if (chunkSize <= 0L) {
            throw new AmazonClientException("Invalid chunk size, chunk size must be great than 0");
        }
        if ((chunkSize & chunkSize - 1L) != 0L) {
            throw new AmazonClientException("Invalid chunk size, chunk size must be aligned on 2^n MB boundaries");
        }
    }

    private void downloadOneChunk(String accountId, String vaultName, String jobId, RandomAccessFile output, long currentPosition, long endPosition, ProgressListener progressListener) {
        long chunkSize = endPosition - currentPosition + 1L;
        TreeHashInputStream input = null;
        int retries = 0;
        while (true) {
            try {
                GetJobOutputRequest req = (GetJobOutputRequest)new GetJobOutputRequest().withAccountId(accountId).withVaultName(vaultName).withRange("bytes=" + currentPosition + "-" + endPosition).withJobId(jobId).withGeneralProgressListener(progressListener);
                GetJobOutputResult jobOutputResult = this.glacier.getJobOutput(req);
                try {
                    input = new TreeHashInputStream(new BufferedInputStream(jobOutputResult.getBody()));
                    this.appendToFile(output, (InputStream)((Object)input));
                }
                catch (NoSuchAlgorithmException e) {
                    try {
                        throw Throwables.failure((Throwable)e, (String)"Unable to compute hash for data integrity");
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(input, (Log)log);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)((Object)input), (Log)log);
                if (null != jobOutputResult.getChecksum()) {
                    if (!input.getTreeHash().equalsIgnoreCase(jobOutputResult.getChecksum())) {
                        SDKProgressPublisher.publishResponseBytesDiscarded((ProgressListener)progressListener, (long)chunkSize);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("reverting " + chunkSize));
                        }
                        throw new IOException("Client side computed hash doesn't match server side hash; possible data corruption");
                    }
                } else {
                    log.warn((Object)"Cannot validate the downloaded output since no tree-hash checksum is returned from Glacier. Make sure the InitiateJob and GetJobOutput requests use tree-hash-aligned ranges.");
                }
                return;
            }
            catch (IOException ioe) {
                if (retries < 3) {
                    ++retries;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(retries + " retry downloadOneChunk accountId=" + accountId + ", vaultName=" + vaultName + ", jobId=" + jobId + ", currentPosition=" + currentPosition + " endPosition=" + endPosition));
                    }
                    try {
                        output.seek(currentPosition);
                    }
                    catch (IOException e) {
                        throw new AmazonClientException("Unable to download the archive: " + ioe.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                throw new AmazonClientException("Unable to download the archive: " + ioe.getMessage(), (Throwable)ioe);
            }
            break;
        }
    }

    private void appendToFile(RandomAccessFile output, InputStream input) throws IOException {
        byte[] buffer = new byte[0x100000];
        int bytesRead = 0;
        while ((bytesRead = input.read(buffer)) >= 0) {
            output.write(buffer, 0, bytesRead);
            if (bytesRead > 0) continue;
        }
    }

    private long calculatePartSize(long fileSize) {
        long partSize = 0x100000L;
        int approxNumParts = 1;
        while (partSize * (long)approxNumParts < fileSize && partSize * 2L <= 0x100000000L) {
            partSize *= 2L;
            approxNumParts *= 2;
        }
        return partSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UploadResult uploadInMultipleParts(String accountId, String vaultName, String archiveDescription, File file, ProgressListener progressListener) {
        long partSize = this.calculatePartSize(file.length());
        String partSizeString = Long.toString(partSize);
        SDKProgressPublisher.publishProgress((ProgressListener)progressListener, (ProgressEventType)ProgressEventType.TRANSFER_PREPARING_EVENT);
        String uploadId = null;
        try {
            InitiateMultipartUploadResult initiateResult = this.glacier.initiateMultipartUpload(new InitiateMultipartUploadRequest().withAccountId(accountId).withArchiveDescription(archiveDescription).withVaultName(vaultName).withPartSize(partSizeString));
            uploadId = initiateResult.getUploadId();
        }
        catch (Throwable t) {
            SDKProgressPublisher.publishProgress((ProgressListener)progressListener, (ProgressEventType)ProgressEventType.TRANSFER_FAILED_EVENT);
            throw Throwables.failure((Throwable)t);
        }
        SDKProgressPublisher.publishProgress((ProgressListener)progressListener, (ProgressEventType)ProgressEventType.TRANSFER_STARTED_EVENT);
        String fileNotFoundMsg = "Unable to find file '" + file.getAbsolutePath() + "'";
        try {
            LinkedList<byte[]> binaryChecksums = new LinkedList<byte[]>();
            for (long currentPosition = 0L; currentPosition < file.length(); currentPosition += partSize) {
                long length = partSize;
                if (currentPosition + partSize > file.length()) {
                    length = file.length() - currentPosition;
                }
                Exception failedException = null;
                boolean completed = false;
                int tries = 0;
                while (!completed && tries < 5) {
                    ++tries;
                    InputSubstream inputSubStream = null;
                    try {
                        inputSubStream = new InputSubstream((InputStream)ResettableInputStream.newResettableInputStream((File)file, (String)fileNotFoundMsg).disableClose(), currentPosition, length, true);
                        String checksum = TreeHashGenerator.calculateTreeHash((InputStream)((Object)inputSubStream));
                        byte[] binaryChecksum = BinaryUtils.fromHex((String)checksum);
                        inputSubStream.reset();
                        UploadMultipartPartRequest req = (UploadMultipartPartRequest)new UploadMultipartPartRequest().withAccountId(accountId).withChecksum(checksum).withBody((InputStream)((Object)inputSubStream)).withRange("bytes " + currentPosition + "-" + (currentPosition + length - 1L) + "/*").withUploadId(uploadId).withVaultName(vaultName).withGeneralProgressListener(progressListener);
                        this.glacier.uploadMultipartPart(req);
                        completed = true;
                        binaryChecksums.add(binaryChecksum);
                        IOUtils.release((Closeable)((Object)inputSubStream), (Log)log);
                    }
                    catch (Exception e) {
                        failedException = e;
                    }
                    finally {
                        IOUtils.release(inputSubStream, (Log)log);
                    }
                }
                if (completed || failedException == null) continue;
                throw failedException;
            }
            String checksum = TreeHashGenerator.calculateTreeHash(binaryChecksums);
            String archiveSize = Long.toString(file.length());
            CompleteMultipartUploadResult completeMultipartUploadResult = this.glacier.completeMultipartUpload(new CompleteMultipartUploadRequest().withAccountId(accountId).withArchiveSize(archiveSize).withVaultName(vaultName).withChecksum(checksum).withUploadId(uploadId));
            String artifactId = completeMultipartUploadResult.getArchiveId();
            SDKProgressPublisher.publishProgress((ProgressListener)progressListener, (ProgressEventType)ProgressEventType.TRANSFER_COMPLETED_EVENT);
            return new UploadResult(artifactId);
        }
        catch (Throwable t) {
            SDKProgressPublisher.publishProgress((ProgressListener)progressListener, (ProgressEventType)ProgressEventType.TRANSFER_FAILED_EVENT);
            this.glacier.abortMultipartUpload(new AbortMultipartUploadRequest(accountId, vaultName, uploadId));
            throw Throwables.failure((Throwable)t, (String)"Unable to finish the upload");
        }
    }

    private UploadResult uploadInSinglePart(String accountId, String vaultName, String archiveDescription, File file, ProgressListener progressListener) {
        String checksum = TreeHashGenerator.calculateTreeHash(file);
        ResettableInputStream is = ResettableInputStream.newResettableInputStream((File)file);
        try {
            SDKProgressPublisher.publishProgress((ProgressListener)progressListener, (ProgressEventType)ProgressEventType.TRANSFER_STARTED_EVENT);
            UploadArchiveRequest req = (UploadArchiveRequest)new UploadArchiveRequest().withAccountId(accountId).withArchiveDescription(archiveDescription).withVaultName(vaultName).withChecksum(checksum).withBody((InputStream)is).withContentLength(file.length()).withGeneralProgressListener(progressListener);
            UploadArchiveResult uploadArchiveResult = this.glacier.uploadArchive(req);
            String artifactId = uploadArchiveResult.getArchiveId();
            SDKProgressPublisher.publishProgress((ProgressListener)progressListener, (ProgressEventType)ProgressEventType.TRANSFER_COMPLETED_EVENT);
            UploadResult uploadResult = new UploadResult(artifactId);
            return uploadResult;
        }
        catch (Throwable t) {
            SDKProgressPublisher.publishProgress((ProgressListener)progressListener, (ProgressEventType)ProgressEventType.TRANSFER_FAILED_EVENT);
            throw Throwables.failure((Throwable)t);
        }
        finally {
            is.release();
        }
    }
}

