/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.route53domains.model.OperationSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListOperationsResult
implements Serializable {
    private ListWithAutoConstructFlag<OperationSummary> operations;
    private String nextPageMarker;

    public List<OperationSummary> getOperations() {
        if (this.operations == null) {
            this.operations = new ListWithAutoConstructFlag();
            this.operations.setAutoConstruct(true);
        }
        return this.operations;
    }

    public void setOperations(Collection<OperationSummary> operations) {
        if (operations == null) {
            this.operations = null;
            return;
        }
        ListWithAutoConstructFlag operationsCopy = new ListWithAutoConstructFlag(operations.size());
        operationsCopy.addAll(operations);
        this.operations = operationsCopy;
    }

    public ListOperationsResult withOperations(OperationSummary ... operations) {
        if (this.getOperations() == null) {
            this.setOperations(new ArrayList<OperationSummary>(operations.length));
        }
        for (OperationSummary value : operations) {
            this.getOperations().add(value);
        }
        return this;
    }

    public ListOperationsResult withOperations(Collection<OperationSummary> operations) {
        if (operations == null) {
            this.operations = null;
        } else {
            ListWithAutoConstructFlag operationsCopy = new ListWithAutoConstructFlag(operations.size());
            operationsCopy.addAll(operations);
            this.operations = operationsCopy;
        }
        return this;
    }

    public String getNextPageMarker() {
        return this.nextPageMarker;
    }

    public void setNextPageMarker(String nextPageMarker) {
        this.nextPageMarker = nextPageMarker;
    }

    public ListOperationsResult withNextPageMarker(String nextPageMarker) {
        this.nextPageMarker = nextPageMarker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOperations() != null) {
            sb.append("Operations: " + this.getOperations() + ",");
        }
        if (this.getNextPageMarker() != null) {
            sb.append("NextPageMarker: " + this.getNextPageMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOperations() == null ? 0 : this.getOperations().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageMarker() == null ? 0 : this.getNextPageMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsResult)) {
            return false;
        }
        ListOperationsResult other = (ListOperationsResult)obj;
        if (other.getOperations() == null ^ this.getOperations() == null) {
            return false;
        }
        if (other.getOperations() != null && !other.getOperations().equals(this.getOperations())) {
            return false;
        }
        if (other.getNextPageMarker() == null ^ this.getNextPageMarker() == null) {
            return false;
        }
        return other.getNextPageMarker() == null || other.getNextPageMarker().equals(this.getNextPageMarker());
    }
}

