// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A specific representation of configurable options for Azure Machine Learning vector index when using it as an Azure
 * OpenAI chat extension.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("azure_ml_index")
@Immutable
public final class AzureMachineLearningIndexChatExtensionConfiguration extends AzureChatExtensionConfiguration {

    /*
     * The parameters for the Azure Machine Learning vector index chat extension.
     */
    @Generated
    @JsonProperty(value = "parameters")
    private AzureMachineLearningIndexChatExtensionParameters parameters;

    /**
     * Get the parameters property: The parameters for the Azure Machine Learning vector index chat extension.
     *
     * @return the parameters value.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters getParameters() {
        return this.parameters;
    }

    /**
     * Creates an instance of AzureMachineLearningIndexChatExtensionConfiguration class.
     *
     * @param parameters the parameters value to set.
     */
    @Generated
    @JsonCreator
    public AzureMachineLearningIndexChatExtensionConfiguration(
        @JsonProperty(value = "parameters") AzureMachineLearningIndexChatExtensionParameters parameters) {
        this.parameters = parameters;
    }
}
