// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A specific representation of configurable options for Azure Search when using it as an Azure OpenAI chat
 * extension.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("azure_search")
@Immutable
public final class AzureSearchChatExtensionConfiguration extends AzureChatExtensionConfiguration {

    /*
     * The parameters to use when configuring Azure Search.
     */
    @Generated
    @JsonProperty(value = "parameters")
    private AzureSearchChatExtensionParameters parameters;

    /**
     * Creates an instance of AzureSearchChatExtensionConfiguration class.
     *
     * @param parameters the parameters value to set.
     */
    @Generated
    @JsonCreator
    public AzureSearchChatExtensionConfiguration(
        @JsonProperty(value = "parameters") AzureSearchChatExtensionParameters parameters) {
        this.parameters = parameters;
    }

    /**
     * Get the parameters property: The parameters to use when configuring Azure Search.
     *
     * @return the parameters value.
     */
    @Generated
    public AzureSearchChatExtensionParameters getParameters() {
        return this.parameters;
    }
}
