// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters for Azure Cognitive Search when used as an Azure OpenAI chat extension. The supported authentication
 * types are APIKey, SystemAssignedManagedIdentity and UserAssignedManagedIdentity.
 */
@Fluent
public final class AzureSearchChatExtensionParameters {

    /*
     * The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     */
    @Generated
    @JsonProperty(value = "authentication")
    private OnYourDataAuthenticationOptions authentication;

    /*
     * The configured top number of documents to feature for the configured query.
     */
    @Generated
    @JsonProperty(value = "top_n_documents")
    private Integer topNDocuments;

    /*
     * Whether queries should be restricted to use of indexed data.
     */
    @Generated
    @JsonProperty(value = "in_scope")
    private Boolean inScope;

    /*
     * The configured strictness of the search relevance filtering. The higher of strictness, the higher of the
     * precision but lower recall of the answer.
     */
    @Generated
    @JsonProperty(value = "strictness")
    private Integer strictness;

    /*
     * Give the model instructions about how it should behave and any context it should reference when generating a
     * response. You can describe the assistant's personality and tell it how to format responses. There's a 100 token
     * limit for it, and it counts against the overall token limit.
     */
    @Generated
    @JsonProperty(value = "role_information")
    private String roleInformation;

    /*
     * The absolute endpoint path for the Azure Cognitive Search resource to use.
     */
    @Generated
    @JsonProperty(value = "endpoint")
    private String endpoint;

    /*
     * The name of the index to use as available in the referenced Azure Cognitive Search resource.
     */
    @Generated
    @JsonProperty(value = "index_name")
    private String indexName;

    /*
     * Customized field mapping behavior to use when interacting with the search index.
     */
    @Generated
    @JsonProperty(value = "fields_mapping")
    private AzureSearchIndexFieldMappingOptions fieldsMapping;

    /*
     * The query type to use with Azure Cognitive Search.
     */
    @Generated
    @JsonProperty(value = "query_type")
    private AzureSearchQueryType queryType;

    /*
     * The additional semantic configuration for the query.
     */
    @Generated
    @JsonProperty(value = "semantic_configuration")
    private String semanticConfiguration;

    /*
     * Search filter.
     */
    @Generated
    @JsonProperty(value = "filter")
    private String filter;

    /*
     * The embedding dependency for vector search.
     */
    @Generated
    @JsonProperty(value = "embedding_dependency")
    private OnYourDataVectorizationSource embeddingDependency;

    /**
     * Creates an instance of AzureSearchChatExtensionParameters class.
     *
     * @param endpoint the endpoint value to set.
     * @param indexName the indexName value to set.
     */
    @Generated
    @JsonCreator
    public AzureSearchChatExtensionParameters(@JsonProperty(value = "endpoint") String endpoint,
        @JsonProperty(value = "index_name") String indexName) {
        this.endpoint = endpoint;
        this.indexName = indexName;
    }

    /**
     * Get the authentication property: The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     *
     * @return the authentication value.
     */
    @Generated
    public OnYourDataAuthenticationOptions getAuthentication() {
        return this.authentication;
    }

    /**
     * Set the authentication property: The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     *
     * @param authentication the authentication value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setAuthentication(OnYourDataAuthenticationOptions authentication) {
        this.authentication = authentication;
        return this;
    }

    /**
     * Get the topNDocuments property: The configured top number of documents to feature for the configured query.
     *
     * @return the topNDocuments value.
     */
    @Generated
    public Integer getTopNDocuments() {
        return this.topNDocuments;
    }

    /**
     * Set the topNDocuments property: The configured top number of documents to feature for the configured query.
     *
     * @param topNDocuments the topNDocuments value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setTopNDocuments(Integer topNDocuments) {
        this.topNDocuments = topNDocuments;
        return this;
    }

    /**
     * Get the inScope property: Whether queries should be restricted to use of indexed data.
     *
     * @return the inScope value.
     */
    @Generated
    public Boolean isInScope() {
        return this.inScope;
    }

    /**
     * Set the inScope property: Whether queries should be restricted to use of indexed data.
     *
     * @param inScope the inScope value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setInScope(Boolean inScope) {
        this.inScope = inScope;
        return this;
    }

    /**
     * Get the strictness property: The configured strictness of the search relevance filtering. The higher of
     * strictness, the higher of the precision but lower recall of the answer.
     *
     * @return the strictness value.
     */
    @Generated
    public Integer getStrictness() {
        return this.strictness;
    }

    /**
     * Set the strictness property: The configured strictness of the search relevance filtering. The higher of
     * strictness, the higher of the precision but lower recall of the answer.
     *
     * @param strictness the strictness value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setStrictness(Integer strictness) {
        this.strictness = strictness;
        return this;
    }

    /**
     * Get the roleInformation property: Give the model instructions about how it should behave and any context it
     * should reference when generating a response. You can describe the assistant's personality and tell it how to
     * format responses. There's a 100 token limit for it, and it counts against the overall token limit.
     *
     * @return the roleInformation value.
     */
    @Generated
    public String getRoleInformation() {
        return this.roleInformation;
    }

    /**
     * Set the roleInformation property: Give the model instructions about how it should behave and any context it
     * should reference when generating a response. You can describe the assistant's personality and tell it how to
     * format responses. There's a 100 token limit for it, and it counts against the overall token limit.
     *
     * @param roleInformation the roleInformation value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setRoleInformation(String roleInformation) {
        this.roleInformation = roleInformation;
        return this;
    }

    /**
     * Get the endpoint property: The absolute endpoint path for the Azure Cognitive Search resource to use.
     *
     * @return the endpoint value.
     */
    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Get the indexName property: The name of the index to use as available in the referenced Azure Cognitive Search
     * resource.
     *
     * @return the indexName value.
     */
    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    /**
     * Get the fieldsMapping property: Customized field mapping behavior to use when interacting with the search index.
     *
     * @return the fieldsMapping value.
     */
    @Generated
    public AzureSearchIndexFieldMappingOptions getFieldsMapping() {
        return this.fieldsMapping;
    }

    /**
     * Set the fieldsMapping property: Customized field mapping behavior to use when interacting with the search index.
     *
     * @param fieldsMapping the fieldsMapping value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setFieldsMapping(AzureSearchIndexFieldMappingOptions fieldsMapping) {
        this.fieldsMapping = fieldsMapping;
        return this;
    }

    /**
     * Get the queryType property: The query type to use with Azure Cognitive Search.
     *
     * @return the queryType value.
     */
    @Generated
    public AzureSearchQueryType getQueryType() {
        return this.queryType;
    }

    /**
     * Set the queryType property: The query type to use with Azure Cognitive Search.
     *
     * @param queryType the queryType value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setQueryType(AzureSearchQueryType queryType) {
        this.queryType = queryType;
        return this;
    }

    /**
     * Get the semanticConfiguration property: The additional semantic configuration for the query.
     *
     * @return the semanticConfiguration value.
     */
    @Generated
    public String getSemanticConfiguration() {
        return this.semanticConfiguration;
    }

    /**
     * Set the semanticConfiguration property: The additional semantic configuration for the query.
     *
     * @param semanticConfiguration the semanticConfiguration value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setSemanticConfiguration(String semanticConfiguration) {
        this.semanticConfiguration = semanticConfiguration;
        return this;
    }

    /**
     * Get the filter property: Search filter.
     *
     * @return the filter value.
     */
    @Generated
    public String getFilter() {
        return this.filter;
    }

    /**
     * Set the filter property: Search filter.
     *
     * @param filter the filter value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    /**
     * Get the embeddingDependency property: The embedding dependency for vector search.
     *
     * @return the embeddingDependency value.
     */
    @Generated
    public OnYourDataVectorizationSource getEmbeddingDependency() {
        return this.embeddingDependency;
    }

    /**
     * Set the embeddingDependency property: The embedding dependency for vector search.
     *
     * @param embeddingDependency the embeddingDependency value to set.
     * @return the AzureSearchChatExtensionParameters object itself.
     */
    @Generated
    public AzureSearchChatExtensionParameters
        setEmbeddingDependency(OnYourDataVectorizationSource embeddingDependency) {
        this.embeddingDependency = embeddingDependency;
        return this;
    }
}
