// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A representation of the log probability information for a single content token, including a list of most likely
 * tokens if 'top_logprobs' were requested.
 */
@Immutable
public final class ChatTokenLogProbabilityResult {

    /*
     * The message content token.
     */
    @Generated
    @JsonProperty(value = "token")
    private String token;

    /*
     * The log probability of the message content token.
     */
    @Generated
    @JsonProperty(value = "logprob")
    private double logprob;

    /*
     * A list of integers representing the UTF-8 bytes representation of the token. Useful in instances where
     * characters are represented by multiple tokens and their byte representations must be combined to generate the
     * correct text representation. Can be null if there is no bytes representation for the token.
     */
    @Generated
    @JsonProperty(value = "bytes")
    private List<Integer> bytes;

    /*
     * The list of most likely tokens and their log probability information, as requested via 'top_logprobs'.
     */
    @Generated
    @JsonProperty(value = "top_logprobs")
    private List<ChatTokenLogProbabilityInfo> topLogprobs;

    /**
     * Creates an instance of ChatTokenLogProbabilityResult class.
     *
     * @param token the token value to set.
     * @param logprob the logprob value to set.
     * @param bytes the bytes value to set.
     * @param topLogprobs the topLogprobs value to set.
     */
    @Generated
    @JsonCreator
    private ChatTokenLogProbabilityResult(@JsonProperty(value = "token") String token,
        @JsonProperty(value = "logprob") double logprob, @JsonProperty(value = "bytes") List<Integer> bytes,
        @JsonProperty(value = "top_logprobs") List<ChatTokenLogProbabilityInfo> topLogprobs) {
        this.token = token;
        this.logprob = logprob;
        this.bytes = bytes;
        this.topLogprobs = topLogprobs;
    }

    /**
     * Get the token property: The message content token.
     *
     * @return the token value.
     */
    @Generated
    public String getToken() {
        return this.token;
    }

    /**
     * Get the logprob property: The log probability of the message content token.
     *
     * @return the logprob value.
     */
    @Generated
    public double getLogprob() {
        return this.logprob;
    }

    /**
     * Get the bytes property: A list of integers representing the UTF-8 bytes representation of the token. Useful in
     * instances where characters are represented by multiple tokens and their byte representations must be combined to
     * generate the correct text representation. Can be null if there is no bytes representation for the token.
     *
     * @return the bytes value.
     */
    @Generated
    public List<Integer> getBytes() {
        return this.bytes;
    }

    /**
     * Get the topLogprobs property: The list of most likely tokens and their log probability information, as requested
     * via 'top_logprobs'.
     *
     * @return the topLogprobs value.
     */
    @Generated
    public List<ChatTokenLogProbabilityInfo> getTopLogprobs() {
        return this.topLogprobs;
    }
}
