/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.batch.CosmosItemOperationBase;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.models.CosmosItemOperation;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;

public final class CosmosBatchOperationResult {
    private final String eTag;
    private final double requestCharge;
    private final int statusCode;
    private final Duration retryAfter;
    private final int subStatusCode;
    private final CosmosItemOperation cosmosItemOperation;
    private CosmosItemSerializer effectiveItemSerializer;
    private ObjectNode resourceObject;

    CosmosBatchOperationResult(String eTag, double requestCharge, ObjectNode resourceObject, int statusCode, Duration retryAfter, int subStatusCode, CosmosItemOperation cosmosItemOperation) {
        Preconditions.checkNotNull(statusCode, "expected non-null statusCode");
        Preconditions.checkNotNull(cosmosItemOperation, "expected non-null cosmosItemOperation");
        this.eTag = eTag;
        this.requestCharge = requestCharge;
        this.resourceObject = resourceObject;
        this.statusCode = statusCode;
        this.retryAfter = retryAfter;
        this.subStatusCode = subStatusCode;
        this.cosmosItemOperation = cosmosItemOperation;
        this.effectiveItemSerializer = cosmosItemOperation instanceof CosmosItemOperationBase ? ((CosmosItemOperationBase)cosmosItemOperation).getEffectiveItemSerializerForResult() : CosmosItemSerializer.DEFAULT_SERIALIZER;
    }

    public String getETag() {
        return this.eTag;
    }

    public double getRequestCharge() {
        return this.requestCharge;
    }

    public <T> T getItem(Class<T> type) {
        T item = null;
        if (this.getResourceObject() != null) {
            item = this.effectiveItemSerializer == CosmosItemSerializer.DEFAULT_SERIALIZER ? (T)new JsonSerializable(this.getResourceObject()).toObject(type) : (T)Utils.parse(this.getResourceObject(), type, this.effectiveItemSerializer);
        }
        return item;
    }

    public Duration getRetryAfterDuration() {
        return this.retryAfter;
    }

    public int getSubStatusCode() {
        return this.subStatusCode;
    }

    public boolean isSuccessStatusCode() {
        return 200 <= this.statusCode && this.statusCode <= 299;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    ObjectNode getResourceObject() {
        return this.resourceObject;
    }

    CosmosItemSerializer getEffectiveItemSerializer() {
        return this.effectiveItemSerializer;
    }

    void setEffectiveItemSerializer(CosmosItemSerializer effectiveItemSerializer) {
        this.effectiveItemSerializer = effectiveItemSerializer;
    }

    public CosmosItemOperation getOperation() {
        return this.cosmosItemOperation;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosBatchOperationResultHelper.setCosmosBatchOperationResultAccessor(new ImplementationBridgeHelpers.CosmosBatchOperationResultHelper.CosmosBatchOperationResultAccessor(){

            @Override
            public ObjectNode getResourceObject(CosmosBatchOperationResult cosmosBatchOperationResult) {
                return cosmosBatchOperationResult.getResourceObject();
            }

            @Override
            public void setResourceObject(CosmosBatchOperationResult cosmosBatchOperationResult, ObjectNode objectNode) {
                cosmosBatchOperationResult.resourceObject = objectNode;
            }

            @Override
            public void setEffectiveItemSerializer(CosmosBatchOperationResult cosmosBatchOperationResult, CosmosItemSerializer effectiveItemSerializer) {
                cosmosBatchOperationResult.setEffectiveItemSerializer(effectiveItemSerializer);
            }
        });
    }

    static {
        CosmosBatchOperationResult.initialize();
    }
}

